/***************************************************************************************\

Module Name:    MtxCs.c

Description:    Access to configuration space registers

References:     

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/


// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "precomp.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                  L O C A L   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                         I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------


/***************************************************************************************\

Function:       csReadWrite

Description:    None.

Parameters:     None.

Return Value:   DWORD
                None.

Comments:       None.

\***************************************************************************************/
DWORD csReadWrite(PCIHANDLE hDevice, DWORD iOffset, void* pvBuffer, DWORD iSize, DWORD iAccess)
{
    DWORD iWalk = 0;
    struct pci_dev* poPciDev = (struct pci_dev*) hDevice;

    if ( iAccess == 0 )
    {
        while (iWalk < iSize)
        {       
            if ((((iOffset + iWalk) & 3) == 0) && ((iSize - iWalk) >= 4))
            {
                ClientPciConfigReadDword( hDevice, (iOffset + iWalk), (DWORD*)((BYTE*)pvBuffer + iWalk) );
                
                iWalk += 4;
            }
            else if ((((iOffset + iWalk) & 1) == 0) && ((iSize - iWalk) >= 2))
            {
                ClientPciConfigReadWord( hDevice, (iOffset + iWalk), (WORD*)((BYTE*)pvBuffer + iWalk) );
            
                iWalk += 2;
            }
            else
            {
                ClientPciConfigReadByte( hDevice, (iOffset + iWalk), ((BYTE*)pvBuffer + iWalk) );
            
                iWalk ++;
            }
        }
    }
    else
    {
        while (iWalk < iSize)
        {       
            if ((((iOffset + iWalk) & 3) == 0) && ((iSize - iWalk) >= 4))
            {
                ClientPciConfigWriteDword( hDevice, (iOffset + iWalk), *((DWORD*)((BYTE*)pvBuffer + iWalk)) );
                
                iWalk += 4;
            }
            else if ((((iOffset + iWalk) & 1) == 0) && ((iSize - iWalk) >= 2))
            {
                ClientPciConfigWriteWord( hDevice, (iOffset + iWalk), *((WORD*)((BYTE*)pvBuffer + iWalk)) );
            
                iWalk += 2;
            }
            else
            {
                ClientPciConfigWriteByte( hDevice, (iOffset + iWalk), *(((BYTE*)pvBuffer + iWalk)) );
            
                iWalk ++;
            }
        }
    }

    return (TRUE);
}
