/***************************************************************************************\

Module Name:    mtx_strintf.h

Description:    This module defines interface functions to access Matrox structures.

Comments:       This is simply used to allow the binary to be compatible with kernels 
                compiled with switches that modifies the ABI.  It allows the binary to
                be kernel-independant.

    Copyright (C) 2004, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTX_STR_INTF_H
#define INC_MTX_STR_INTF_H

/*-------------------------------------------------------------------------------------*\
                                 H E A D E R   F I L E S
\*-------------------------------------------------------------------------------------*/
#include "mtx_mem_type.h"

/*-------------------------------------------------------------------------------------*\
                          C O N S T A N T S   A N D   T Y P E S
\*-------------------------------------------------------------------------------------*/

struct mtx_region;
struct mtx_device;
struct mtx_context;

typedef struct mtx_region*  HREGION;
typedef struct mtx_context* HCONTEXT;

typedef UINT32              PHYSADDR;

typedef int (*CORE_IOCTL)(MTXHANDLE, unsigned int, unsigned long);

typedef struct 
{
    CHAR*   pszName;
    VOID*   pvObject;
} LutParm;

/*-------------------------------------------------------------------------------------*\
                   G L O B A L   V A R I A B L E   R E F E R E N C E S
\*-------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------*\
                 I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
\*-------------------------------------------------------------------------------------*/

EXTERN_C STACK_LINKAGE HREGION   MtxRegion_Alloc(HCONTEXT ctx, size_t, mtx_memory_type, mtx_memory_scope, HREGION);
EXTERN_C STACK_LINKAGE void      MtxRegion_Free(HCONTEXT, HREGION);
EXTERN_C STACK_LINKAGE HREGION   MtxRegion_FindFromBase(HDEVICE hDev, PHYSADDR iBase);
EXTERN_C STACK_LINKAGE HREGION   MtxRegion_FindFromVirtual(HDEVICE hDev, void* kaddr);

EXTERN_C STACK_LINKAGE MEMHANDLE MtxRegion_GetLinear( HREGION hRegion );
EXTERN_C STACK_LINKAGE UINT32    MtxRegion_GetPhys( HREGION hRegion );
EXTERN_C STACK_LINKAGE UINT32    MtxRegion_GetSize( HREGION hRegion );
EXTERN_C STACK_LINKAGE void      MtxRegion_IncrementRefCount( HREGION hRegion );
EXTERN_C STACK_LINKAGE void      MtxRegion_DecrementRefCount( HREGION hRegion );
EXTERN_C STACK_LINKAGE int       MtxRegion_DecrementRefCountAndTest( HREGION hRegion );

EXTERN_C STACK_LINKAGE PCIHANDLE MtxPciDevice_GetHostHandle( void );

EXTERN_C STACK_LINKAGE PCIHANDLE MtxDevice_GetPciHandle( HDEVICE hDevice );
EXTERN_C STACK_LINKAGE HREGION   MtxDevice_GetRegisters( HDEVICE hDevice );
EXTERN_C STACK_LINKAGE HREGION   MtxDevice_GetFrameBuffer( HDEVICE hDevice );
EXTERN_C STACK_LINKAGE UINT32    MtxDevice_GetBmFlags( HDEVICE hDevice );
EXTERN_C STACK_LINKAGE MTXHANDLE MtxDevice_GetPrivate( HDEVICE hDevice );
EXTERN_C STACK_LINKAGE void*     MtxDevice_GetRegisterHandle( HDEVICE hDevice );

EXTERN_C STACK_LINKAGE MTXHANDLE MtxContext_GetPrivate( HCONTEXT hContext );

EXTERN_C STACK_LINKAGE void      MtxIoctl_Register(UINT32 iIoControlNumber, CORE_IOCTL pfnCallback, 
                                                   LBOOL bCoreIoControl, LBOOL bRestritedAccess, LBOOL bSuperUserOnly);

EXTERN_C STACK_LINKAGE INT32     MtxParm_InitLut( UINT32 iLutIndex, LutParm aoLutParm[] );

#endif  /* #ifndef INC_MTX_STR_INTF_H */
