/***************************************************************************************\

    File Name:      mtx_coreintf.h

    Description:    Interface to core driver.

    References:     None.

    Copyright (c) 2004, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTX_COREINTF_H
#define INC_MTX_COREINTF_H

/*-------------------------------------------------------------------------------------*\
                                 H E A D E R   F I L E S
\*-------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------*\
                          C O N S T A N T S   A N D   T Y P E S
\*-------------------------------------------------------------------------------------*/

/*
 * mtx_core_driver_t
 *
 * common interface to any core driver used to driver specific boards
 */
typedef struct mtx_core_driver {

    /* Init driver so it can enable devices properly */
    STACK_LINKAGE  int         (*init)(void);
    
    /* Cleanup driver */
    STACK_LINKAGE  int         (*cleanup)(void);
    
    /* Enable a device in core driver and return a handle to core record (can be hdev) */
    STACK_LINKAGE  MTXHANDLE   (*enable)(HDEVICE hdev, HCONTEXT hctx, unsigned long ulBmFlags);

    /* Disable a valid device from the core driver */
    STACK_LINKAGE  void        (*disable)(MTXHANDLE hcoredev);

    /* Open a new context on a device and return a handle to core record (can be hctx) */
    STACK_LINKAGE  MTXHANDLE   (*open)(MTXHANDLE hcoredev, MTXHANDLE hctx);

    /* Close a context on a device */
    STACK_LINKAGE  void        (*close)(MTXHANDLE hcoredev, MTXHANDLE hcorectx);

    /* Top-half interrupt routine callback */
    STACK_LINKAGE  int         (*irq_fast)(MTXHANDLE hcoredev);

    /* Bottom-half interrupt routine callback */
    STACK_LINKAGE  void        (*irq_slow)(unsigned long ulcoredev);

} mtx_core_driver_t;    

/*-------------------------------------------------------------------------------------*\
                   G L O B A L   V A R I A B L E   R E F E R E N C E S
\*-------------------------------------------------------------------------------------*/

extern   mtx_core_driver_t mtx_parhl_driver;

/*-------------------------------------------------------------------------------------*\
                 I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
\*-------------------------------------------------------------------------------------*/

#endif  // #ifndef INC_MTX_COREINTF_H
