#!/bin/bash

SOURCES=$1

HEADERS=$SOURCES/include

CFLAGS="-D__KERNEL__ \
-nostdinc  \
-Werror -Wimplicit-function-declaration"

CFLAGS="$CFLAGS -I$HEADERS -I$HEADERS/asm/mach-default"

echo "#include <linux/types.h>
#include <linux/agp_backend.h>
typedef struct agp_bridge_data agp_bridge_data;
agp_bridge_data *mtx_agp_backend_acquire(struct pci_dev *dev) 
{
    return agp_backend_acquire(dev);
}" > agp_test$$.c

gcc $CFLAGS -c agp_test$$.c > /dev/null 2>&1
rm -f agp_test$$.c

if [ -f agp_test$$.o ]; then
    rm -f agp_test$$.o
    echo 1
else
    echo 0
fi

