/***************************************************************************************\

Module Name:    MtxPci.h

Description:    Interface for PCI devices.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXPCI_H
#define INC_MTXPCI_H

/* --------------------------------------------------------------------------------------
                               H E A D E R   F I L E S
   --------------------------------------------------------------------------------------*/

#include "MtxCs.h"

/*--------------------------------------------------------------------------------------
                         C O N S T A N T S   A N D   T Y P E S
  --------------------------------------------------------------------------------------*/

/* Compare function for pciSearchDevice*/
typedef DWORD (*PCISEARCH)(
    PCIHANDLE   hPci, 
    void*       pvRefData
);

/* PCI Location Information*/
typedef struct {

    DWORD function  :3;     /* 2::0*/
    DWORD device    :5;     /* 7::3*/
    DWORD bus       :8;     /* 15::8*/
    DWORD reserved  :16;    /* 31::16*/

} PCILOCATION;

/* --------------------------------------------------------------------------------------
                   G L O B A L   V A R I A B L E   R E F E R E N C E S
   --------------------------------------------------------------------------------------*/

/* --------------------------------------------------------------------------------------
                 I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
   --------------------------------------------------------------------------------------*/

EXTERN_C DWORD pciScan(
    PCISEARCH       fnSearch, 
    void*           pvRefData
);

EXTERN_C DWORD pciScanBus(
    PCISEARCH       fnSearch,
    void*           pvRefData
);

EXTERN_C DWORD pciFindCapability(
    PCIHANDLE       hPci, 
    DWORD*          pdwOffset, 
    DWORD           dwCapId
);

EXTERN_C DWORD pciFindPMCapability(
    PCIHANDLE       hPci, 
    DWORD*          pdwOffset
);

EXTERN_C DWORD pciFindAGPCapability(
    PCIHANDLE       hPci, 
    DWORD*          pdwOffset
);

EXTERN_C DWORD pciGetTermbase(
    PCIHANDLE       hPci, 
    DWORD           dwOffset, 
    DWORD*          pdwBase, 
    DWORD*          pdwSize
);

EXTERN_C DWORD pciGetLocation(
    PCIHANDLE       hPci,
    PCILOCATION*    pInfo
);

EXTERN_C PCIHANDLE pciGetHandle( 
    DWORD      dwBus,
    DWORD      dwDevice,
    DWORD      dwFunction
);

/* --------------------------------------------------------------------------------------
                             I N L I N E S   A N D   M A C R O S
   --------------------------------------------------------------------------------------*/

#endif  /* #ifndef INC_MTXPCI_H*/
