/***************************************************************************************\

Module Name:    MtxMem.inl

Description:    Access to physical memory.

References:     MtxMem.htm

    Copyright (c) 2001, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXMEM_INL
#define INC_MTXMEM_INL

// --------------------------------------------------------------------------------------
//                                  I N L I N E S
// --------------------------------------------------------------------------------------

/***************************************************************************************\

Function:       memAlloc

Description:    None.

Parameters:     dwSize

Return Value:   MEMHANDLE
                Not Specified.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE MEMHANDLE memAlloc(
    DWORD           dwSize)
{
    return memFileAlloc(dwSize, "UNKNOWN", 0);
}
    
/***************************************************************************************\

Function:       memReadWrite

Description:    None.

Parameters:     hMemory
                dwOffset
                pvBuffer
                dwSize
                dwAccess

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE void memReadWrite(
    MEMHANDLE   hMemory,
    DWORD       dwOffset,
    void*       pvBuffer,
    DWORD       dwSize,
    DWORD       dwAccess)
{
    if (dwAccess == 0)
    {
        memRead(hMemory, dwOffset, pvBuffer, dwSize);
    }
    else
    {
        memWrite(hMemory, dwOffset, pvBuffer, dwSize);
    }
}

/***************************************************************************************\

Function:       memReadByte

Description:    None.

Parameters:     hMemory
                dwOffset
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE void memReadByte(
    MEMHANDLE   hMemory,
    DWORD       dwOffset,
    BYTE*       pvBuffer)
{
    *pvBuffer = cpuReadMemoryByte((BYTE*)hMemory + dwOffset);
}

/***************************************************************************************\

Function:       memReadWord

Description:    None.

Parameters:     hMemory
                dwOffset
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE void memReadWord(
    MEMHANDLE   hMemory,
    DWORD       dwOffset,
    WORD*       pvBuffer)
{
    *pvBuffer = cpuReadMemoryWord((BYTE*)hMemory + dwOffset);
}

/***************************************************************************************\

Function:       memReadDword

Description:    None.

Parameters:     hMemory
                dwOffset
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE void memReadDword(
    MEMHANDLE   hMemory,
    DWORD       dwOffset,
    DWORD*      pvBuffer)
{
    *pvBuffer = cpuReadMemoryDword((BYTE*)hMemory + dwOffset);
}

/***************************************************************************************\

Function:       memWriteByte

Description:    None.

Parameters:     hMemory
                dwOffset
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE void memWriteByte(
    MEMHANDLE   hMemory,
    DWORD       dwOffset,
    BYTE        pvBuffer)
{
    cpuWriteMemoryByte((BYTE*)hMemory + dwOffset, pvBuffer);
}

/***************************************************************************************\

Function:       memWriteWord

Description:    None.

Parameters:     hMemory
                dwOffset
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE void memWriteWord(
    MEMHANDLE   hMemory,
    DWORD       dwOffset,
    WORD        pvBuffer)
{
    cpuWriteMemoryWord((BYTE*)hMemory + dwOffset, pvBuffer);
}

/***************************************************************************************\

Function:       memWriteDword

Description:    None.

Parameters:     hMemory
                dwOffset
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE void memWriteDword(
    MEMHANDLE   hMemory,
    DWORD       dwOffset,
    DWORD       pvBuffer)
{
    cpuWriteMemoryDword((BYTE*)hMemory + dwOffset, pvBuffer);
}

#endif  // #ifndef INC_MTXMEM_INL
