/***************************************************************************************\

Module Name:    MtxMem.h

Description:    Interface for physical memory access.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXMEM_H
#define INC_MTXMEM_H

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "MtxType.h"
#if 1
//##if ! defined(DEBUG) || defined (INC_PRECOMP_H)
#define INLINE_RELEASE inline
#else
#define INLINE_RELEASE
#endif 

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

EXTERN_C STACK_LINKAGE INLINE_RELEASE MEMHANDLE memAlloc(
    DWORD           dwSize
);

EXTERN_C STACK_LINKAGE MEMHANDLE memFileAlloc(
    DWORD           dwSize,
    PSTR            pszFileName,
    INT             iLine
);

EXTERN_C STACK_LINKAGE DWORD memFree(
    MEMHANDLE       hMemory
);

EXTERN_C STACK_LINKAGE MEMHANDLE memMap(
    DWORD           dwPhysical, 
    DWORD           dwSize
);

EXTERN_C STACK_LINKAGE DWORD memUnmap(
    MEMHANDLE       hMemory
);

EXTERN_C STACK_LINKAGE INLINE_RELEASE void memReadWrite(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    void*           pvBuffer,
    DWORD           lSize,
    DWORD           lAccess
);

EXTERN_C STACK_LINKAGE void memRead(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    void*           pvBuffer,
    DWORD           lSize
);

EXTERN_C STACK_LINKAGE INLINE_RELEASE void memReadDword(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    DWORD*          pvBuffer
);

EXTERN_C STACK_LINKAGE INLINE_RELEASE void memReadWord(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    WORD*           pvBuffer
);

EXTERN_C STACK_LINKAGE INLINE_RELEASE void memReadByte(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    BYTE*           pvBuffer
);

EXTERN_C STACK_LINKAGE void memWrite(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    void*           pvBuffer,
    DWORD           lSize
);

EXTERN_C STACK_LINKAGE INLINE_RELEASE void memWriteDword(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    DWORD           pvBuffer
);

EXTERN_C STACK_LINKAGE INLINE_RELEASE void memWriteWord(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    WORD            pvBuffer
);

EXTERN_C STACK_LINKAGE INLINE_RELEASE void memWriteByte(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    BYTE            pvBuffer
);

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_MTXMEM_H
