/***************************************************************************************\

Module Name:    MtxLdt.h

Description:    Interface for local descriptor table.

References:     MtxLdt.htm

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXLDT_H
#define INC_MTXLDT_H

// --------------------------------------------------------------------------------------
//                      H E A D E R   F I L E S   R E Q U I R E D
// --------------------------------------------------------------------------------------

#include "MtxDte.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

typedef DWORD LDTHANDLE;

// --------------------------------------------------------------------------------------
//                  G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

EXTERN_C LDTHANDLE ldtAlloc(void);

EXTERN_C void ldtFree(
    LDTHANDLE   iEntry
);

EXTERN_C DWORD ldtRead(
    LDTHANDLE   iEntry, 
    void*       pvBuffer
);

EXTERN_C DWORD ldtWrite(
    LDTHANDLE   iEntry, 
    void*       pvBuffer
);

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif // #ifndef INC_MTXLDT_H
