/***************************************************************************************\

Module Name:    MtxIo.inl

Description:    Inline functions for MtxIo module.

References:     MtxIo.htm

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXIO_INL
#define INC_MTXIO_INL

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------


/***************************************************************************************\

Function:       ioRead

Description:    Read from an IO register

Parameters:     hPort           IO port number
                pvBuffer        Output data
                lSize           Number of bytes to read

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
void ioRead(IOHANDLE hPort, void* pvBuffer, DWORD lSize)
{
    ioReadWrite(hPort, pvBuffer, lSize, 0);
}

/****************************************************************************************\

Function:       ioWrite

Description:    Write to an IO register

Parameters:     hPort           IO port number
                pvBuffer        Input data
                lSize           Number of bytes to write

Return Value:   

Comments:       None.

\****************************************************************************************/
void ioWrite(IOHANDLE hPort, void* pvBuffer, DWORD lSize)
{
    ioReadWrite(hPort, pvBuffer, lSize, 1);
}

/****************************************************************************************\

Function:       ioReadByte

Description:    Read from an IO register

Parameters:     hPort           IO port number
                pvBuffer        Output data

Return Value:   

Comments:       None.

\****************************************************************************************/
void ioReadByte(IOHANDLE hPort, BYTE* pvBuffer)
{
    ioRead(hPort, pvBuffer, sizeof(*pvBuffer));
}

/****************************************************************************************\

Function:       ioReadWord

Description:    Read from an IO register

Parameters:     hPort           IO port number
                pvBuffer        Output data

Return Value:   

Comments:       None.

\****************************************************************************************/
void ioReadWord(IOHANDLE hPort, WORD* pvBuffer)
{
    ioRead(hPort, pvBuffer, sizeof(*pvBuffer));
}

/****************************************************************************************\

Function:       ioReadDword

Description:    Read from an IO register

Parameters:     hPort           IO port number
                pvBuffer        Output data

Return Value:   

Comments:       None.

\****************************************************************************************/
void ioReadDword(IOHANDLE hPort, DWORD* pvBuffer)
{
    ioRead(hPort, pvBuffer, sizeof(*pvBuffer));
}

/****************************************************************************************\

Function:       ioWriteByte

Description:    Write to an IO register

Parameters:     hPort           IO port number
                pvBuffer        Input data

Return Value:   

Comments:       None.

\****************************************************************************************/
void ioWriteByte(IOHANDLE hPort, BYTE pvBuffer)
{
    ioWrite(hPort, &pvBuffer, sizeof(pvBuffer));
}

/****************************************************************************************\

Function:       ioWriteWord

Description:    Write to an IO register

Parameters:     hPort           IO port number
                pvBuffer        Input data

Return Value:   

Comments:       None.

\****************************************************************************************/
void ioWriteWord(IOHANDLE hPort, WORD pvBuffer)
{
    ioWrite(hPort, &pvBuffer, sizeof(pvBuffer));
}

/****************************************************************************************\

Function:       ioWriteDword

Description:    Write to an IO register

Parameters:     hPort           IO port number
                pvBuffer        Input data

Return Value:   

Comments:       None.

\****************************************************************************************/
void ioWriteDword(IOHANDLE hPort, DWORD pvBuffer)
{
    ioWrite(hPort, &pvBuffer, sizeof(pvBuffer));
}

#endif  // #ifndef INC_MTXIO_INL
