/***************************************************************************************\

Module Name:    MtxIo.h

Description:    Definitions for IO access.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXIO_H
#define INC_MTXIO_H

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "MtxType.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

typedef DWORD IOHANDLE;

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

EXTERN_C DWORD ioReadWrite(
    IOHANDLE   hPort,
    void*      pvBuffer,
    DWORD      lSize,
    DWORD      lAccess
);

EXTERN_C DWORD ioRead(
    IOHANDLE   hPort, 
    void*      pvBuffer, 
    DWORD      lSize
);

EXTERN_C DWORD ioReadByte(
    IOHANDLE   hPort,
    BYTE*      pvBuffer
);

EXTERN_C DWORD ioReadWord(
    IOHANDLE   hPort,
    WORD*      pvBuffer
);

EXTERN_C DWORD ioReadDword(
    IOHANDLE   hPort,
    DWORD*     pvBuffer
);

EXTERN_C DWORD ioWrite(
    IOHANDLE   hPort, 
    void*      pvBuffer, 
    DWORD      lSize
);

EXTERN_C DWORD ioWriteByte(
    IOHANDLE   hPort,
    BYTE       bData
);

EXTERN_C DWORD ioWriteWord(
    IOHANDLE   hPort,
    WORD       wData
);

EXTERN_C DWORD ioWriteDword(
    IOHANDLE   hPort,
    DWORD      dData
);

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_MTXIO_H
