/***************************************************************************************\

Module Name:    MtxFile.h

Description:    Basic file interface.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXFILE_H
#define INC_MTXFILE_H

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "MtxType.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

typedef DWORD FILEHANDLE;

// Constants for fhOpen function
#define FHOPEN_READONLY             0
#define FHOPEN_WRITEONLY            1
#define FHOPEN_READWRITE            2

// Constants for fhSeek function
#define FHSEEK_BEGIN                0
#define FHSEEK_CURRENT              1
#define FHSEEK_END                  2

// Constants for hFile
#define FILEHANDLE_STDIN            0
#define FILEHANDLE_STDOUT           1
#define FILEHANDLE_STDERR           2

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

EXTERN_C FILEHANDLE fhCreate(
    char* pszFileName
);

EXTERN_C FILEHANDLE fhOpen(
    char* pszFileName,
    DWORD lMode
);

EXTERN_C void fhClose(
    FILEHANDLE hFile
);

EXTERN_C DWORD fhRead(
    FILEHANDLE  hFile,
    void*       pvBuffer,
    DWORD       lSize
);

EXTERN_C DWORD fhWrite(
    FILEHANDLE  hFile,
    void*       pvBuffer,
    DWORD       lSize
);

EXTERN_C long fhSeek(
    FILEHANDLE  hFile,
    DWORD       lType,
    long        lPos
);

EXTERN_C long fhTell(
    FILEHANDLE hFile
);

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_MTXFILE_H
