/***************************************************************************************\

Module Name:    MtxCs.h

Description:    Definitions for CS access.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXCS_H
#define INC_MTXCS_H

/***************************************************************************************\
                                 H E A D E R   F I L E S
\***************************************************************************************/

#include "MtxType.h"

/***************************************************************************************\
                          C O N S T A N T S   A N D   T Y P E S
\***************************************************************************************/

/***************************************************************************************\
                   G L O B A L   V A R I A B L E   R E F E R E N C E S
\***************************************************************************************/

/***************************************************************************************\
                 I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
\***************************************************************************************/

EXTERN_C DWORD csReadWrite(
    PCIHANDLE  hPci,
    DWORD      iOffset,
    void*      pvBuffer,
    DWORD      iSize,
    DWORD      iAccess
);

INLINE DWORD csRead(
    PCIHANDLE  hPci, 
    DWORD      iOffset, 
    void*      pvBuffer, 
    DWORD      iSize
);

INLINE DWORD csReadDword(
    PCIHANDLE  hPci, 
    DWORD      iOffset, 
    DWORD*     pvBuffer
);

INLINE DWORD csReadWord(
    PCIHANDLE  hPci, 
    DWORD      iOffset, 
    WORD*      pvBuffer
);

INLINE DWORD csReadByte(
    PCIHANDLE  hPci, 
    DWORD      iOffset, 
    BYTE*      pvBuffer
);

INLINE DWORD csWrite(
    PCIHANDLE  hPci, 
    DWORD      iOffset, 
    void*      pvBuffer, 
    DWORD      iSize
);

INLINE DWORD csWriteDword(
    PCIHANDLE  hPci, 
    DWORD      iOffset, 
    DWORD      pvBuffer
);

INLINE DWORD csWriteWord(
    PCIHANDLE  hPci, 
    DWORD      iOffset, 
    WORD       pvBuffer
);

INLINE DWORD csWriteByte(
    PCIHANDLE  hPci, 
    DWORD      iOffset, 
    BYTE       pvBuffer
);

/***************************************************************************************\
                             I N L I N E S   A N D   M A C R O S
\***************************************************************************************/

/***************************************************************************************\

Function:       csRead

Description:    None.

Parameters:     None.

Return Value:   DWORD
                None.

Comments:       None.

\***************************************************************************************/
DWORD csRead(PCIHANDLE hDevice, DWORD iOffset, void* pvBuffer, DWORD iSize)
{
    return csReadWrite(hDevice, iOffset, pvBuffer, iSize, 0);
}


/***************************************************************************************\

Function:       csReadDword

Description:    None.

Parameters:     None.

Return Value:   DWORD
                None.

Comments:       None.

\***************************************************************************************/
DWORD csReadDword(PCIHANDLE hPci, DWORD iOffset, DWORD* pvBuffer)
{
    return csRead(hPci, iOffset, pvBuffer, sizeof(DWORD));
}


/***************************************************************************************\

Function:       csReadWord

Description:    None.

Parameters:     None.

Return Value:   DWORD
                None.

Comments:       None.

\***************************************************************************************/
DWORD csReadWord(PCIHANDLE hPci, DWORD iOffset, WORD* pvBuffer)
{
    return csRead(hPci, iOffset, pvBuffer, sizeof(WORD));
}


/***************************************************************************************\

Function:       csReadByte

Description:    None.

Parameters:     None.

Return Value:   DWORD
                None.

Comments:       None.

\***************************************************************************************/
DWORD csReadByte(PCIHANDLE hPci, DWORD iOffset, BYTE* pvBuffer)
{
    return csRead(hPci, iOffset, pvBuffer, sizeof(BYTE));
}


/***************************************************************************************\

Function:       csWrite

Description:    None.

Parameters:     None.

Return Value:   DWORD
                None.

Comments:       None.

\***************************************************************************************/
DWORD csWrite(PCIHANDLE hDevice, DWORD iOffset, void* pvBuffer, DWORD iSize)
{
    return csReadWrite(hDevice, iOffset, pvBuffer, iSize, 1);
}


/***************************************************************************************\

Function:       csWriteDword

Description:    None.

Parameters:     None.

Return Value:   DWORD
                None.

Comments:       None.

\***************************************************************************************/
DWORD csWriteDword(PCIHANDLE hPci, DWORD iOffset, DWORD pvBuffer)
{
    return csWrite(hPci, iOffset, &pvBuffer, sizeof(pvBuffer));
}


/***************************************************************************************\

Function:       csWriteWord

Description:    None.

Parameters:     None.

Return Value:   DWORD 
                None.

Comments:       None.

\***************************************************************************************/
DWORD csWriteWord(PCIHANDLE hPci, DWORD iOffset, WORD pvBuffer)
{
    return csWrite(hPci, iOffset, &pvBuffer, sizeof(pvBuffer));
}


/***************************************************************************************\

Function:       csWriteByte

Description:    None.

Parameters:     None.

Return Value:   DWORD 
                None.

Comments:       None.

\***************************************************************************************/
DWORD csWriteByte(PCIHANDLE hPci, DWORD iOffset, BYTE pvBuffer)
{
    return csWrite(hPci, iOffset, &pvBuffer, sizeof(pvBuffer));
}

#endif  /* #ifndef INC_MTXCS_H */
