/*-------------------------------------------------------------------------------------*\

Module Name:    MtxTypesLnx.h

Description:    Content all OS specific types, constants, macros that should be defined
                to get the OS independent code to compile.  You can include a header file
                that defines all this stuff or you can define each conposant individually.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\*-------------------------------------------------------------------------------------*/

#ifndef INC_MTXTYPESLNX_H
#define INC_MTXTYPESLNX_H

/*---------------------------------------------------------------------------------------*\
                        H E A D E R   F I L E S   R E Q U I R E D
\*---------------------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

#ifdef XF86_SUPPORT
#include <X11/Xmd.h>
#endif

#ifndef __KERNEL__
#include <sys/types.h>
#include <stddef.h>
#endif

#include <linux/types.h>
#include <stdarg.h>

#if defined(__KERNEL__) && ((__GNUC__ < 3) || !defined(__cplusplus))
#include <linux/nls.h>
#endif
	
#ifdef __cplusplus
};
#endif

/*-------------------------------------------------------------------------------------*\
                                    C O N S T A N T S
\*-------------------------------------------------------------------------------------*/


#define _T(string)      L ## string

#define IN
#define OUT
#define INOUT

#define TRUE            1
#define FALSE           0

#define __cdecl
#define __stdcall
#define CALLBACK
#define FAR
#ifdef __cplusplus
 #define INLINE          __inline__
 #define FINLINE         __inline__
#else
 #define INLINE          static __inline__
 #define FINLINE         static __inline__
#endif
#define OPTIONAL   
#define FIELD_OFFSET(type, field)    ((LONG)&(((type *)0)->field))

/* invalidate pragmas */
#define MTX_CODE_SEG_BEGIN
#define MTX_CODE_SEG_END
#define MM_CODE_SEG_BEGIN
#define MM_CODE_SEG_END

#ifndef EXTERN_C
  #ifdef __cplusplus
    #define EXTERN_C extern "C"
  #else  
    #define EXTERN_C extern
  #endif 
#endif 

#define NEG_NULL    ((unsigned)(~0))

/* Must add this to compile for ia64. */
#ifndef FASTCALL
  #if defined(_M_IX86)
    #define FASTCALL _fastcall
  #else
    #define FASTCALL(x) x
  #endif
#endif

#if __GNUC__ >= 3 
#define STACK_LINKAGE   __attribute__((regparm(0)))
#else
#define STACK_LINKAGE
#endif

#define FLOAT_TO_DWORD_ZERO 0x00000000
#define FLOAT_TO_DWORD_ONE  0x3F800000

typedef enum _DBG_LEVEL
{
    DBGL_CRITICAL       = 0,
    DBGL_ERROR,          
    DBGL_WARNING,
    DBGL_INFO,
    DBGL_DETAIL,
    DBGL_NOISE,
    DBGL_FORCE_LONG     = -1 
} DBG_LEVEL;

/*-------------------------------------------------------------------------------------*\
                             T Y P E   D E F I N I T I O N S
\*-------------------------------------------------------------------------------------*/

#if defined(__KERNEL__)
  typedef __s8                  INT8;
  typedef __s16                 INT16;
  typedef __s32                 INT32;
  typedef __s64                 INT64;
  typedef __u8                  UINT8;
  typedef __u16                 UINT16;
  typedef __u32                 UINT32;
  typedef __u64                 UINT64;
  typedef __u32                 BOOL;
#else
  #ifdef XF86_SUPPORT
    #define BOOL LBOOL
    #if !defined(LONG64)
      typedef int64_t           INT64;
    #endif
  #else
    typedef int8_t              INT8;
    typedef int16_t             INT16;
    typedef int32_t             INT32;
    typedef int64_t             INT64;
    typedef u_int32_t           BOOL;
  #endif
  typedef u_int8_t              UINT8;
  typedef u_int16_t             UINT16;
  typedef u_int32_t             UINT32;
  typedef u_int64_t             UINT64;
#endif
#ifndef XF86_SUPPORT 
typedef UINT8                   BYTE;      
#endif
typedef UINT16                  WORD;
typedef UINT32                  DWORD;
typedef BYTE*                   LPBYTE;
typedef BYTE*                   PBYTE;
typedef UINT8                   BOOL8;
typedef UINT32                  BOOL32;
typedef unsigned short          USHORT;
typedef float                   FLOAT;
typedef char *                  PSZ;
typedef double                  DOUBLE;
typedef long double             LDOUBLE;
#define __ULONG__
#ifdef __amd64__
typedef UINT32                  LBOOL;
typedef UINT32                  MUTEX;
typedef INT32                   NTSTATUS;
typedef INT32                   LONG;
typedef UINT32                  ULONG;
typedef UINT32                  ULONG_PTR;
typedef UINT32*                 PLONG;
#else
typedef unsigned long           LBOOL;
typedef unsigned long           MUTEX;
typedef long                    NTSTATUS;
typedef long                    LONG;
typedef unsigned long           ULONG;
typedef unsigned long           ULONG_PTR;
typedef unsigned long*          PLONG;
#endif
typedef unsigned long           HANDLE;
typedef ULONG                   FLONG;
typedef char                    CHAR;
typedef unsigned char           UCHAR;
typedef void                    VOID;
typedef void *                  LPVOID;
typedef const char *            PSTR;
typedef PSTR                    LPSTR;
typedef PSTR                    LPCSTR;
typedef BOOL                    BOOLEAN;
typedef int                     INT;
typedef unsigned int            UINT;
typedef unsigned int            UINT_PTR;
typedef DWORD                   DWORD_PTR;
#ifndef __STRICT_ANSI__
typedef unsigned long long      DWORDLONG;
typedef long long               LONGLONG;
typedef unsigned long long      ULONGLONG;
#endif
typedef void                    (*PFN);
typedef wchar_t                 TCHAR;
typedef char                    ACHAR;
typedef TCHAR                   WCHAR;
typedef TCHAR*                  LPWSTR;
typedef const TCHAR*            PWSTR;
typedef LONG                    HRESULT;
typedef BYTE*                   FLATPTR;

typedef HANDLE                  MTXHANDLE;
typedef void*                   MEMHANDLE;
typedef DWORD                   PCIHANDLE;

/* These types are to be used for bit fields only
   to ensure all fields are of the same type. */
#ifdef __amd64__
typedef UINT32                  BFUNSIGNED;     /* Unsigned bit field */
typedef INT32                   BFSIGNED;       /* Signed bit field */
typedef UINT32                  BFBOOL;         /* Boolean bit field (1-bit only) */
#else
typedef unsigned long           BFUNSIGNED;     /* Unsigned bit field */
typedef signed long             BFSIGNED;       /* Signed bit field */
typedef unsigned long           BFBOOL;         /* Boolean bit field (1-bit only) */
#endif

typedef struct 
{                                                   
     LONG   x;                                      
     LONG   y;                                      
     
} LPOINT, POINT, POINT32;

typedef struct
{                                                   
     LONG   left;                                   
     LONG   top;                                    
     LONG   right;                                  
     LONG   bottom;                                 
     
} LRECT, RECT, RECT32;

typedef struct
{
    LONG        cx;
    LONG        cy;
    
} LSIZE, SIZE, SIZE32;

/* Handy structure for (Width, Height) packed in a ULONG.*/
typedef struct
{
    USHORT  usWidth;
    USHORT  usHeight;
    
} USHORT_SIZE;

typedef struct
{
    ULONG   ulWidth;
    ULONG   ulHeight;
    
} ULONG_SIZE;

typedef LPOINT POINTL;
typedef LSIZE SIZEL;
typedef LRECT RECTL;
typedef HANDLE HWND;


#ifndef __STRICT_ANSI__

enum {
    BMF_1BPP    = 1,
    BMF_4BPP    = 4,
    BMF_8BPP    = 8,
    BMF_16BPP   = 16,
    BMF_24BPP   = 24,
    BMF_32BPP   = 32,
};

typedef union _LARGE_INTEGER{
    
    struct{
        
        DWORD LowPart;
        LONG HighPart;
    };
    
    LONGLONG QuadPart;
    
} LARGE_INTEGER;

typedef union _ULARGE_INTEGER{
    
    struct{
        
        DWORD LowPart;
        ULONG HighPart;
    };
    
    ULONGLONG QuadPart;
    
} ULARGE_INTEGER;

#endif

typedef FLOAT FLOATOBJ;
#define FLOATOBJ_Add(pFloat, pFloat2)      (*pFloat += *pFloat2)
#define FLOATOBJ_Mul(pFloat, pFloat2)      (*pFloat *= *pFloat2)
#define FLOATOBJ_SetLong(pFloat, lLong)   (*pFloat = lLong)
#define FLOATOBJ_GetLong(pFloat)          ((LONG)*pFloat)
#define FLOATOBJ_MulLong(pFloat, lLong)   (*pFloat *= lLong)
#define FLOATOBJ_DivLong(pFloat, lLong)   (*pFloat /= lLong)
#define FLOATOBJ_SetFloat(pFloat, fFloat) (*pFloat = fFloat)

typedef struct _ENUMRECTS {
    
    ULONG  c;
    RECTL  arcl[1];
  
} ENUMRECTS;

struct mtx_device;
typedef struct mtx_device*  HDEVICE;

/*-------------------------------------------------------------------------------------*\
                    G L O B A L   V A R I A B L E   R E F E R E N C E S
\*-------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------*\
                 I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
\*-------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------*\
                             I N L I N E S   A N D   M A C R O S
\*-------------------------------------------------------------------------------------*/

/* Macro used to generate compilation message */

#define chSTR(x)    #x
#define chSTR2(x)   chSTR(x)

#if 0
    #define COMPMSG(x)  message(__FILE__ "(" chSTR2(__LINE__) ") : " #x)
#else
    #define COMPMSG(x)  
#endif

/* Define for enumeration to use to be compatible with Windows 9x. */
#define ENUM(Name)     enum Name

#endif  /* #ifndef INC_MTXTYPESLNX_H */
