#!/bin/sh

#====================================================
#
#  Matrox Driver Install Script
#
#  Copyright (C) 2001, Matrox Graphics Inc.
#
#  Author : Karl Lessard
#  Last modified : July 2001.
#====================================================

VMAJOR=1
VMINOR=0
VPATCH=0

clear
echo ""
echo "Matrox Driver Install Script"

ROOT=
restartX=0
undo=0
BCK_SFFX=".mgabck.$VMAJOR.$VMINOR.$VPATCH"

# check for superuser mode
if ! test -r /proc/kmsg ; then
    echo ""
    echo "Error: You must be logged in as Root to run this program. Exiting."
    echo ""
    exit 1
fi
    

# parsing options

n=$#
i=0
for arg in $* ; do
    param=`echo $arg | cut -d'=' -f1`
    value=`echo $arg | cut -d'=' -f2`
    case $param in
        "root") ROOT=$value ;;
        "restore") undo=1 ;;
    esac;
done

# check X version

Xpath=`which X 2> /dev/null`
if [ $? -eq 1 ] ; then
    echo ""
    echo "Error: X server not found. Exiting."
    echo ""
    exit 1
elif [ $Xpath = "/usr/X11R6/bin/X" ] ; then
    Xpath="/usr/X11R6"
else
    echo ""
    echo "Please enter the full path to your current X11R6 directory: "
    read Xpath
fi
Xpath=$ROOT$Xpath

Xversion=`X -version 2>&1 | grep -s "XFree86 Version" | cut -d" " -f3 | sed -e "s/\([^\.]*\.[^\.]*\.[^\.]*\)\.[^\.]*/\1/"`

if ! test -e ./xfree86/$Xversion ; then
    echo "The drivers included in this installation package do not support"
    echo "this version of XFree86. Exiting.                               "
    echo ""
    exit 1
fi


# RESTORE MODE: restoring backup files

if [ $undo -eq 1 ] ; then
    restoreDRI=0
    restoreX=0
    restoreHAL=0
    removeHAL=0
    echo ""
    echo "You are about to restore your previous display drivers."
    echo -n "Press return to continue, or any other key to cancel. "
    read -n 1 reallyundo
    if [ ! -z $reallyundo ] ; then
        echo ""
        echo ""
        echo "Restore canceled. Exiting."
        echo ""
        exit 0
    fi
    if test -e $Xpath/lib/modules/drivers/mga_drv.o$BCK_SFFX; then
        echo ""
        echo -n "Restore XFree86 mga driver (y/n)? "
        read str_restoreX
        if [ $str_restoreX = 'Y' -o $str_restoreX = 'y' ] ; then 
            mv -f $Xpath/lib/modules/drivers/mga_drv.o$BCK_SFFX $Xpath/lib/modules/drivers/mga_drv.o
            restoreX=1
            restartX=1
        fi
    fi
    if test -e $Xpath/lib/modules/drivers/mga_hal_drv.o$BCK_SFFX; then
        echo ""
        echo -n "Restore Matrox HAL library (y/n)? "
        read str_restoreHAL
        if [ $str_restoreHAL = 'Y' -o $str_restoreHAL = 'y' ] ; then 
            mv -f $Xpath/lib/modules/drivers/mga_hal_drv.o$BCK_SFFX $Xpath/lib/modules/drivers/mga_hal_drv.o
            restoreHAL=1
            restoreX=1
        fi
    elif test -e $Xpath/lib/modules/drivers/mga_hal_drv.o; then
        echo ""
        echo -n "Remove Matrox HAL library (y/n)? "
        read str_removeHAL
        if [ $str_removeHAL = 'Y' -o $str_removeHAL = 'y' ] ; then
            rm -f $Xpath/lib/modules/drivers/mga_hal_drv.o
            removeHAL=1
            restoreX=1
        fi
    fi
    if test -e $Xpath/lib/modules/dri/mga_dri.so$BCK_SFFX; then
        echo ""
        echo -n "Restore DRI module (y/n)? "
        read str_restoreDRI
        if [ $str_restoreDRI = 'y' -o $str_restoreDRI = 'Y' ] ; then
            mv -f $Xpath/lib/modules/dri/mga_dri.so$BCK_SFFX $Xpath/lib/modules/dri/mga_dri.so
            restoreDRI=1
        fi
    fi
    echo ""
    echo "==========================================================================="
    echo ""
    echo "Summary:"
    echo ""

    echo -n "XFree86 driver:        "
    if [ $restoreX -eq 1 ] ; then echo "Restored."
    else echo "No changes made."
    fi
    
    echo -n "HAL library:           "
    if [ $restoreHAL -eq 1 ] ; then echo "Restored."
    elif [ $removeHAL -eq 1 ] ; then echo "Removed."
    else echo "No changes made."
    fi
    
    echo -n "DRI module:            "
    if [ $restoreDRI -eq 1 ] ; then echo "Restored."
    else echo "No changes made."
    fi
    
    echo ""
    if [ $restartX -eq 1 ] ; then
        echo "You must restart the X server for changes to take effect."
    fi
    echo ""
    exit 0
fi


# NORMAL MODE: installing components

echo ""
echo "Welcome to the Matrox driver installation script. This program "
echo "will update your system with the latest display drivers for    "
echo "XFree86.                                                   " 
echo ""
echo "Press any key to continue."

read -n 1

echo ""

clear


# X server driver

mga=0
installX=0
if test -e ./xfree86/$Xversion/drivers/mga_drv.o ; then
    diff ./xfree86/$Xversion/drivers/mga_drv.o $Xpath/lib/modules/drivers/mga_drv.o > /dev/null 2>&1 
    if [ $? -ne 0 ] ; then
        mga=1
    fi
fi

if [ $mga -eq 1 ] ; then
    echo "==============================================================="
    echo ""
    echo "XFree86 MGA Driver (mga_drv.o)"
    echo ""
    echo "This is the XFree86 2D driver. This version includes support for"
    echo "PowerDesk; a graphical utility for configuring Matrox graphics  "
    echo "adapters.                                                       " 
    echo ""
    echo -n "Install mga XFree86 driver (y/n)? "

    read str_installX

    echo ""

    if [ $str_installX ] ; then
        if [ $str_installX = 'Y' -o $str_installX = 'y' ] ; then
            installX=1
            echo ""
            echo -n "Installing mga_drv.o..."
            rm $Xpath/lib/modules/drivers/mga_drv.o.mgabck.* > /dev/null 2>&1
            install -m 775 -S $BCK_SFFX -b ./xfree86/$Xversion/drivers/mga_drv.o $Xpath/lib/modules/drivers
            echo "done."
            restartX=1
        else
            installX=0
        fi
    else
        installX=0
    fi
    echo ""
fi


# HAL lib

hal=0
installHAL=0
if test -e ./xfree86/$Xversion/drivers/mga_hal_drv.o ; then
    diff ./xfree86/$Xversion/drivers/mga_hal_drv.o $Xpath/lib/modules/drivers/mga_hal_drv.o > /dev/null 2>&1 
    if [ $? -ne 0 ] ; then
        hal=1
    fi
fi

if [ $hal -eq 1 ] ; then
    echo "==========================================================================="
    echo ""
    echo "Matrox HAL Library (mga_hal_drv.o)"
    echo ""
    echo "The Matrox HAL (Hardware Abstraction Layer) is a special library "
    echo "used to enable features that are not supported by the standard   "
    echo "XFree86 driver. It is required to enable DualHead, TV Output, and"
    echo "DVI support on the G400, and multiple monitor support on the G200"
    echo "Multi-Monitor series. It is also required for certain PowerDesk  "
    echo "features such as adjusting refresh rates and screen positioning. "
    echo "The HAL module is not required for DualHead support on the G550  "
    echo "and G450 graphics adapters.                                      "
    echo ""
    echo -n "Install Matrox HAL library (y/n)? "

    read str_installHAL

    echo ""
    if [ $str_installHAL ] ; then
        if [ $str_installHAL = 'Y' -o $str_installHAL = 'y' ] ; then
            installHAL=1
            echo ""
            echo -n "Installing mga_hal_drv.o..."
            rm $Xpath/lib/modules/drivers/mga_hal_drv.o.mgabck.* > /dev/null 2>&1
            install -m 775 -S $BCK_SFFX -b ./xfree86/$Xversion/drivers/mga_hal_drv.o $Xpath/lib/modules/drivers
            echo "done."
            restartX=1
        else
            installHAL=0
        fi
    else
        installHAL=0
    fi
    echo ""
fi

# libGL module 

dri=0
installDRI=0
if test -e ./xfree86/$Xversion/dri/mga_dri.so ; then
    diff ./xfree86/$Xversion/dri/mga_dri.so $Xpath/lib/modules/dri/mga_dri.so > /dev/null 2>&1
    if [ $? -ne 0 ] ; then
        dri=1
    fi
fi

if [ $dri -eq 1 ] ; then
    echo "==========================================================================="
    echo ""
    echo "DRI module (mga_dri.so)"
    echo ""
    echo "This is an updated version of the DRI module that is included"
    echo "with XFree86 4.1.0. DRI must be configured properly before   "
    echo "installing this update.                                      "
    echo ""
    echo -n "Update DRI module (y/n)? "

    read str_installDRI

    echo ""
    if [ $str_installDRI ] ; then
        if [ $str_installDRI = 'Y' -o $str_installDRI = 'y' ] ; then
            installDRI=1
            echo ""
            echo -n "Installing mga_dri.so..."
            rm $Xpath/lib/modules/dri/mga_dri.so.mgabck.* > /dev/null 2>&1
            install -m 775 -S $BCK_SFFX -b ./xfree86/$Xversion/dri/mga_dri.so $Xpath/lib/modules/dri
            echo "done."
        else
            installDRI=0
        fi
    else
        installDRI=0
    fi
    echo ""
fi

# end

echo "==========================================================================="
echo ""
echo "Summary:"
echo ""
    
echo -n "XFree86 driver:        "
if [ $installX -eq 1 ] ; then echo "Updated."
elif [ $mga -eq 0 ] ; then echo "Up to date."
else echo "No changes made."
fi
    
echo -n "HAL library:           "
if [ $installHAL -eq 1 ] ; then echo "Updated."
elif [ $hal -eq 0 ] ; then echo "Up to date."
else echo "No changes made."
fi

echo -n "DRI module:            "
if [ $installDRI -eq 1 ] ; then echo "Updated."
elif [ $dri -eq 0 ] ; then echo "Up to date."
else echo "No changes made."
fi
    
echo ""
if [ $restartX -eq 1 ] ; then
    echo "You must restart the X server for changes to take effect."
fi
echo ""

exit 0
