/***************************************************************************************\

Module Name:    MtxLdt.c

Description:    Interface for local descriptor table.

References:     MtxLdt.htm

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/


// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "precomp.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                  L O C A L   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                         I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

/***************************************************************************************\

Function:       ldtAlloc

Description:    None.

Parameters:     void

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
LDTHANDLE ldtAlloc(void)
{
    return (LDTHANDLE)0;
}


/***************************************************************************************\

Function:       ldtFree

Description:    None.

Parameters:     iEntry

Return Value:   void 
                Not Specified.

Comments:       None.

\***************************************************************************************/
void ldtFree(
    LDTHANDLE iEntry)
{
}


/***************************************************************************************\

Function:       ldtRead

Description:    None.

Parameters:     iEntry
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD ldtRead(
    LDTHANDLE   iEntry, 
    void*       pvBuffer)
{
    GDTHANDLE   lLdtReg;
    DWORD       oLdtInfo[2];

    lLdtReg = ldtrRead(&oLdtInfo);
    if (lLdtReg)
    {
        MEMHANDLE poLdtTable;

        poLdtTable = dteGetBase(&oLdtInfo);
        if (poLdtTable)
        {
            if (iEntry <= dteGetLimit(&oLdtInfo))
            {
                memRead(poLdtTable, (iEntry & (~7)), pvBuffer, 8);

                return TRUE;
            }
        }
    }

    return FALSE;
}


/***************************************************************************************\

Function:       ldtWrite

Description:    None.

Parameters:     iEntry
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD ldtWrite(
    LDTHANDLE   iEntry,
    void*       pvBuffer)
{
    return FALSE;
}
