/***************************************************************************************\

Module Name:    MtxDte.c

Description:    

References:     

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/


// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "precomp.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                  L O C A L   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                         I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

/***************************************************************************************\

Function:       dteRead

Description:    None.

Parameters:     iEntry
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD dteRead(
    DWORD iEntry, 
    void* pvBuffer)
{
    if (iEntry & 4)
    {
        return ldtRead(iEntry, pvBuffer);
    }
    else
    {
        return gdtRead(iEntry, pvBuffer);
    }
}

/***************************************************************************************\

Function:       dteWrite

Description:    None.

Parameters:     iEntry
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD dteWrite(
    DWORD iEntry,
    void* pvBuffer)
{
    if (iEntry & 4)
    {
        return ldtWrite(iEntry, pvBuffer);
    }
    else
    {
        return gdtWrite(iEntry, pvBuffer);
    }
}

/***************************************************************************************\

Function:       dteGetBase

Description:    None.

Parameters:     pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD dteGetBase(
    void* pvBuffer)
{
    DTE* poEntry = (DTE*)pvBuffer;

    if (poEntry)
    {
        return ( ( ( ( poEntry->LO >> 16L ) & 0xFFFFL ) << 0L  ) |
                 ( ( ( poEntry->HI >> 0L  ) & 0x00FFL ) << 16L ) |
                 ( ( ( poEntry->HI >> 24L ) & 0x00FFL ) << 24L ) );
    }

    return 0;
}


/***************************************************************************************\

Function:       dteGetLimit

Description:    None.

Parameters:     pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD dteGetLimit(
    void* pvBuffer)
{
    DTE* poEntry = (DTE*)pvBuffer;

    if (poEntry)
    {
        if (poEntry->HI & 0x00800000L)
        {
            return ( ( ( ( poEntry->LO >> 0L  ) & 0xFFFFL ) << 12L ) | 
                     ( ( ( poEntry->HI >> 16L ) & 0x000FL ) << 28L ) | 0xFFFL);
        }
        else
        {
            return ( ( ( ( poEntry->LO >> 0L  ) & 0xFFFFL ) << 0L  ) | 
                     ( ( ( poEntry->HI >> 16L ) & 0x000FL ) << 16L ) );
        }
    }

    return 0;
}


/***************************************************************************************\

Function:       dteSetBase

Description:    None.

Parameters:     pvBuffer
                lBase

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
void dteSetBase(
    void*   pvBuffer,
    DWORD   lBase)
{
    DTE* poEntry = (DTE*)pvBuffer;

    if (poEntry)
    {
        poEntry->LO = ((poEntry->LO & 0x0000FFFFL) | ((lBase & 0x0000FFFFL) << 16L));
        poEntry->HI = ((poEntry->HI & 0x00FFFF00L) | ((lBase & 0xFF000000L) | ((lBase & 0x00FF0000L) >> 16L)));
    }
}


/***************************************************************************************\

Function:       dteSetLimit

Description:    None.

Parameters:     pvBuffer
                lLimit

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
void dteSetLimit(
    void*   pvBuffer,
    DWORD   lLimit)
{
    DTE* poEntry = (DTE*)pvBuffer;

    if (poEntry)
    {
        if (lLimit < 0x100000L)
        {
            poEntry->LO = ((poEntry->LO & 0xFFFF0000L) | ((lLimit & 0x0000FFFFL) << 0L));
            poEntry->HI = ((poEntry->HI & 0xFF70FFFFL) | ((lLimit & 0x000F0000L) << 0L) | 0x00000000L);
        }
        else
        {
            poEntry->LO = ((poEntry->LO & 0xFFFF0000L) | ((lLimit & 0x0FFFF000L) >> 12L));
            poEntry->HI = ((poEntry->HI & 0xFF70FFFFL) | ((lLimit & 0xF0000000L) >> 12L) | 0x00800000L);
        }
    }    
}
