/***************************************************************************************\

Module Name:    MtxVxd0.h

Description:    None.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXVXD0_H
#define INC_MTXVXD0_H

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "MtxType.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

#define IOCTL_MTXVXD_VERSION            0x9C406400
#define IOCTL_MTXVXD_READ_MSR           0x9C406404
#define IOCTL_MTXVXD_WRITE_MSR          0x9C406408
#define IOCTL_MTXVXD_READ_CONFIG        0x9C406410
#define IOCTL_MTXVXD_WRITE_CONFIG       0x9C406414
#define IOCTL_MTXVXD_READ_CR3           0x9C406418
#define IOCTL_MTXVXD_READ_CR0           0x9C40641C
#define IOCTL_MTXVXD_READ_CR4           0x9C406420
#define IOCTL_MTXVXD_WBINVD             0x9C406424
#define IOCTL_MTXVXD_GET_TERMBASE       0x9C406428
#define IOCTL_MTXVXD_MAP                0x9C406434
#define IOCTL_MTXVXD_UNMAP              0x9C406438
#define IOCTL_MTXVXD_FLUSHTLB           0x9C40643C
#define IOCTL_MTXVXD_READ_IO            0x9C406440
#define IOCTL_MTXVXD_WRITE_IO           0x9C406444
#define IOCTL_MTXVXD_FIND_CAPABILITY    0x9C406448
#define IOCTL_MTXVXD_READ_CPU           0x9C40644C
#define IOCTL_MTXVXD_WRITE_CPU          0x9C406450

#define MTXVXD_VERSION_NUMBER           0x55AA0001
#define ERROR_UNKNOWN_SERVICE           1

typedef struct _OUT_READ_VERSION {
DWORD ulVersion;
} OUT_READ_VERSION;

typedef struct _IN_READ_MSR {
DWORD ulIndex;
} IN_READ_MSR;

typedef struct _OUT_READ_MSR {
DWORD ulDataLo;
DWORD ulDataHi;
} OUT_READ_MSR;

typedef struct _IN_WRITE_MSR {
DWORD ulIndex;
DWORD ulDataLo;
DWORD ulDataHi;
} IN_WRITE_MSR;

typedef struct _IN_MAP {   
DWORD ulPhysicalBase;      
DWORD ulSizeBytes;         
} IN_MAP;                  

typedef struct _OUT_MAP {  
DWORD pvUserAddress;      
DWORD hMemory;             
} OUT_MAP;                 

typedef struct _IN_UNMAP { 
DWORD hMemory;             
} IN_UNMAP;                

typedef struct _IN_READ_CONFIG {
DWORD hPci;
DWORD ulOffset;
DWORD ulSizeBytes;
} IN_READ_CONFIG;

typedef struct _IN_WRITE_CONFIG {
DWORD hPci;
DWORD ulOffset;
DWORD ulSizeBytes;
} IN_WRITE_CONFIG;

typedef struct _OUT_READ_CR0 {
DWORD ulCR0;
} OUT_READ_CR0;

typedef struct _OUT_READ_CR3 {
DWORD ulCR3;
} OUT_READ_CR3;

typedef struct _OUT_READ_CR4 {
DWORD ulCR4;
} OUT_READ_CR4;

typedef struct _IN_GET_TERMBASE {
DWORD hPci;
DWORD ulOffset;
} IN_GET_TERMBASE;

typedef struct _OUT_GET_TERMBASE {
DWORD ulBase;
DWORD ulMask;
} OUT_GET_TERMBASE;

typedef struct _IN_READ_IO {
DWORD ulHandle;
DWORD ulSize;
} IN_READ_IO;

typedef struct _IN_WRITE_IO {
DWORD ulHandle;
DWORD ulSize;
} IN_WRITE_IO;

typedef struct _IN_FIND_CAPABILITY {
DWORD hPci;
DWORD ulCapId;
} IN_FIND_CAPABILITY;

typedef struct _OUT_FIND_CAPABILITY {
DWORD ulOffset;
} OUT_FIND_CAPABILITY;

typedef struct _IN_READ_CPU {
DWORD dwBank;
DWORD dwIndex;
} IN_READ_CPU;

typedef struct _IN_WRITE_CPU {
DWORD dwBank;
DWORD dwIndex;
} IN_WRITE_CPU;

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_MTXVXD0_H
