/***************************************************************************************\

Module Name:    MtxVxd.h

Description:    Definitions for MtxVxd services.

References:     \doc\MtxVxd.doc

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXVXD_H
#define INC_MTXVXD_H

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "MtxType.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// Current Services
EXTERN_C DWORD MtxVxdVersion       ();

EXTERN_C DWORD MtxVxdReadCR0       ();

EXTERN_C DWORD MtxVxdReadCR3       ();

EXTERN_C DWORD MtxVxdReadCR4       ();

EXTERN_C DWORD MtxVxdWBINVD        ();

EXTERN_C DWORD MtxVxdFlushTLB      ();

EXTERN_C HANDLE MtxVxdBeginCriticalSection(
    char*   szType, 
    DWORD   dwID
);

EXTERN_C DWORD MtxVxdEndCriticalSection(
    HANDLE hMutex
);

// Old Services

// Use memMap instead
EXTERN_C void* MtxVxdMap(
    DWORD      ulBase, 
    DWORD      ulSize, 
    DWORD*     phMemory
);

// Use memUnmap instead
EXTERN_C DWORD MtxVxdUnmap(
    DWORD      hMemory
);

// Use msrRead instead
EXTERN_C DWORD MtxVxdReadMSR(
    DWORD      ulIndex, 
    void*      pRegister
);

// Use msrWrite instead
EXTERN_C DWORD MtxVxdWriteMSR(
    DWORD      ulIndex, 
    void*      pRegister
);

// Use csRead instead
EXTERN_C DWORD MtxVxdReadConfig(
    DWORD      hPci, 
    DWORD      ulOffset, 
    void*      pvBuffer, 
    DWORD      ulSize);

// Use csWrite instead
EXTERN_C DWORD MtxVxdWriteConfig(
    DWORD      hPci, 
    DWORD      ulOffset, 
    void*      pvBuffer, 
    DWORD      ulSize
);

// Use csReadByte instead
EXTERN_C DWORD MtxVxdReadConfigByte(
    DWORD      hPci, 
    DWORD      ulOffset, 
    BYTE*      pbData);

// Use csReadWord instead
EXTERN_C DWORD MtxVxdReadConfigWord(
    DWORD      hPci, 
    DWORD      ulOffset, 
    WORD*      pwData);

// Use csReadDword instead
EXTERN_C DWORD MtxVxdReadConfigDword(
    DWORD     hPci, 
    DWORD     ulOffset, 
    DWORD*    pdData
);

// Use csWriteByte instead
EXTERN_C DWORD MtxVxdWriteConfigByte(
    DWORD     hPci, 
    DWORD     ulOffset, 
    BYTE      bData
);

// Use csWriteWord instead
EXTERN_C DWORD MtxVxdWriteConfigWord(
    DWORD     hPci, 
    DWORD     ulOffset, 
    WORD      wData
);

// Use csWriteDword instead
EXTERN_C DWORD MtxVxdWriteConfigDword(
    DWORD    hPci, 
    DWORD    ulOffset, 
    DWORD    dData
);

// Use pciGetTermbase instead
EXTERN_C DWORD MtxVxdGetTermBase(
    DWORD   hPci, 
    DWORD   ulOffset,
    DWORD*  pulBase, 
    DWORD*  pulMask
);

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_MTXVXD_H
