/***************************************************************************************\

Module Name:    MtxMem.h

Description:    Interface for physical memory access.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXMEM_H
#define INC_MTXMEM_H

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "MtxType.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

typedef DWORD MEMHANDLE;

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

EXTERN_C MEMHANDLE memAlloc(
    DWORD           dwSize
);

EXTERN_C DWORD memFree(
    MEMHANDLE       hMemory
);

EXTERN_C MEMHANDLE memMap(
    DWORD           dwPhysical, 
    DWORD           dwSize
);

EXTERN_C DWORD memUnmap(
    MEMHANDLE       hMemory
);

EXTERN_C DWORD memReadWrite(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    void*           pvBuffer,
    DWORD           lSize,
    DWORD           lAccess
);

EXTERN_C DWORD memRead(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    void*           pvBuffer,
    DWORD           lSize
);

EXTERN_C DWORD memReadDword(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    DWORD*          pvBuffer
);

EXTERN_C DWORD memReadWord(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    WORD*           pvBuffer
);

EXTERN_C DWORD memReadByte(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    BYTE*           pvBuffer
);

EXTERN_C DWORD memWrite(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    void*           pvBuffer,
    DWORD           lSize
);

EXTERN_C DWORD memWriteDword(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    DWORD           pvBuffer
);

EXTERN_C DWORD memWriteWord(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    WORD            pvBuffer
);

EXTERN_C DWORD memWriteByte(
    MEMHANDLE       hMemory,
    DWORD           lOffset,
    BYTE            pvBuffer
);

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_MTXMEM_H
