/***************************************************************************************\

Module Name:    MtxGdt.h

Description:    Interface to global descriptor table.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXGDT_H
#define INC_MTXGDT_H

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "MtxDte.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

typedef DWORD GDTHANDLE;

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

EXTERN_C GDTHANDLE gdtAlloc(void);

EXTERN_C void gdtFree(
    GDTHANDLE   iEntry
);

EXTERN_C DWORD gdtRead(
    GDTHANDLE   iEntry,
    void*       pvBuffer
);

EXTERN_C DWORD gdtWrite(
    GDTHANDLE   iEntry,
    void*       pvBuffer
);

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_MTXGDT_H
