/***************************************************************************************\

Module Name:    MtxDte.h

Description:    Interface for descriptor table entries.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXDTE_H
#define INC_MTXDTE_H

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "MtxMem.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

typedef struct _DTE {
    DWORD LO;
    DWORD HI;
} DTE;

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

EXTERN_C DWORD dteRead(
    DWORD       iSelector,
    void*       pvBuffer
);

EXTERN_C DWORD dteWrite(
    DWORD       iSelector,
    void*       pvBuffer
);

EXTERN_C MEMHANDLE dteGetBase(
    void*       pvBuffer
);

EXTERN_C DWORD dteGetLimit(
    void*       pvBuffer
);

EXTERN_C void dteSetBase(
    void*       pvBuffer,
    MEMHANDLE   lBase
);

EXTERN_C void dteSetLimit(
    void*       pvBuffer,
    DWORD       lLimit
);

EXTERN_C void dteMap(
    void*       pvBuffer,
    MEMHANDLE   lBase,
    DWORD       lLimit
);

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_MTXDTE_H
