/***************************************************************************************\

Module Name:    new.cpp

Description:    None.

References:     None.

    Copyright (c) 2002, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

// --------------------------------------------------------------------------------------
//                        I N C L U D E S   A N D   U S I N G S
// --------------------------------------------------------------------------------------

#include "mtxc++.h"
#include "mtx_drv.h"
#include "MtxMem.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               G L O B A L   F U N C T I O N   D E C L A R A T I O N S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//     I N L I N E S,  M A C R O S,  A N D   T E M P L A T E   D E F I N I T I O N S
// --------------------------------------------------------------------------------------

/****************************************************************************************\

Function:       new

Description:    new operator for C++

Parameters:     sz  :   size to allocate

Return Value:   void* 

Comments:       None.

\****************************************************************************************/
void* __cdecl operator new(size_t sz)
{
  #ifdef MEMORY_STATS
    return mtx_mem_stats_alloc(sz, "UNKNOWN", 0);
  #else
    void* ptr = mtx_mem_alloc(sz + sizeof(size_t));
    if (ptr)
    {
        /* First DWORD is used to store size of memory chunk */
        *(size_t*)ptr = sz;

        return (void*)((char*)ptr + sizeof(size_t));
    }

    /* Allocation failed */
    return NULL;
  #endif
}

/****************************************************************************************\

Function:       new

Description:    new operator for C++

Parameters:     sz  :       Size to allocate
                pszFile     File where the allocation occured
                iLine       Line where the allocation occured

Return Value:   void* 

Comments:       None.

\****************************************************************************************/
void* __cdecl operator new(size_t sz, const char* pszFile, int iLine)
{
  #ifdef MEMORY_STATS
    return mtx_mem_stats_alloc(sz, pszFile, iLine);
  #else
    return ::operator new(sz);
  #endif
}

/****************************************************************************************\

Function:       delete

Description:    overload delete operator for C++.

Parameters:     m   :   memory to delete

Return Value:   void 
                None.

Comments:       None.

\****************************************************************************************/
void __cdecl operator delete(void* ptr)
{
    if (ptr != NULL)
    {
      #ifdef MEMORY_STATS
        mtx_mem_stats_free(ptr);
      #else
        size_t sz;
    
        /* Retrieve size from address pointer */
        ptr = (void*)((char*)ptr - sizeof(size_t));
        sz = *(size_t*)ptr;

        if (ptr && sz)
        {
            /* Retrieve size from address pointer */
            mtx_mem_free(ptr, sz + sizeof(size_t));
            return TRUE;
        }
        else
        {
            dbgOutput("in mtxvxd: failed to free memory\n");
        }
      #endif
    }
}


/****************************************************************************************\

Function:       new

Description:    vector new operator for C++

Parameters:     sz  :   size to allocate

Return Value:   void* 

Comments:       None.

\****************************************************************************************/
void* __cdecl operator new [] (size_t sz)
{
    return ::operator new(sz);
}

/****************************************************************************************\

Function:       new

Description:    vector new operator for C++

Parameters:     sz  :       Size to allocate
                pszFile     File where the allocation occured
                iLine       Line where the allocation occured

Return Value:   void* 

Comments:       None.

\****************************************************************************************/
void* __cdecl operator new [] (size_t sz, const char* pszFile, int iLine)
{
    return ::operator new(sz, pszFile, iLine);
}

/****************************************************************************************\

Function:       new

Description:    vector delete operator for C++

Parameters:     ptr  :   vector to free

Return Value:   void* 

Comments:       None.

\****************************************************************************************/
void __cdecl operator delete [] (void* ptr)
{
    return ::operator delete(ptr);
}

/****************************************************************************************\

Function:       new

Description:    placement new operator for C++

Parameters:     sz  :   size to allocate

Return Value:   void* 

Comments:       None.

\****************************************************************************************/
void* __cdecl operator new(size_t sz, void* ptr)
{
    return ptr;
}
