/***************************************************************************************\

Module Name:    mtxc++.h

Description:    C++ support for MTX drivers.

References:     None.

    Copyright (c) 2002, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXCPLUSPLUS_H
#define INC_MTXCPLUSPLUS_H

// --------------------------------------------------------------------------------------
//                        I N C L U D E S   A N D   U S I N G S
// --------------------------------------------------------------------------------------

#ifdef __cplusplus
extern "C" {
#endif
#include <linux/types.h>
#include <stdarg.h>
#ifdef __cplusplus
};
#endif

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

#define __cdecl

#ifndef INLINE
#define INLINE inline
#endif

#ifndef EXTERN_C
 #ifdef __cplusplus
  #define EXTERN_C extern "C"
 #else
  #define EXTERN_C
 #endif
#endif

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               G L O B A L   F U N C T I O N   D E C L A R A T I O N S
// --------------------------------------------------------------------------------------

#ifdef __cplusplus
void* __cdecl operator new(size_t sz);
void* __cdecl operator new(size_t sz, const char* pszFile, int iLine);
void __cdecl operator delete(void* m);
void* __cdecl operator new [] (size_t sz);
void* __cdecl operator new [] (size_t sz, const char* pszFile, int iLine);
void __cdecl operator delete [] (void* ptr);
void* __cdecl operator new(size_t sz, void* ptr);

EXTERN_C void __pure_virtual();

#ifdef MEMORY_STATS
  #define NEW new(__FILE__, __LINE__)
#else
  #define NEW new
#endif

#endif // __cplusplus

EXTERN_C void __cdecl mtx_call_global_ctors(void);
EXTERN_C void __cdecl mtx_call_global_dtors(void);

EXTERN_C void atexit(void (*)(void));

// --------------------------------------------------------------------------------------
//     I N L I N E S,  M A C R O S,  A N D   T E M P L A T E   D E F I N I T I O N S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_MTXCPLUSPLUS_H
