// map standard header

#ifndef _MTLMAP_
#define _MTLMAP_
#include "MtlFunctional.h"
#include "MtlXTree.h"

#ifndef MTLBEGIN
#define MTLBEGIN        namespace Mtl{
#define MTLEND          }
#endif

MTLBEGIN
		// TEMPLATE CLASS map
template<class _K, class _Ty, class _Pr = less<_K>,
	class _A = allocator<_Ty> >
class Map {
public:
	typedef Map<_K, _Ty, _Pr, _A> _Myt;
	typedef Pair<const _K, _Ty> ValueType;
	struct _Kfn : public unary_function<ValueType, _K> {
		const _K& operator()(const ValueType& _X) const
		{return (_X.first); }
		};
	class ValueCompare
		: public binary_function<ValueType, ValueType, BOOL> {
		friend class Map<_K, _Ty, _Pr, _A>;
	public:
		BOOL operator()(const ValueType& _X,
			const ValueType& _Y) const
			{return (comp(_X.first, _Y.first)); }
		ValueCompare(_Pr _Pred)
			: comp(_Pred) {}
		_Pr comp;
		};
	typedef _K KeyType;
	typedef _Ty ReferentType;
	typedef _Pr KeyCompare;
	typedef _A AllocatorType;
	typedef typename _A::reference _Tref;
	typedef _Tree<_K, ValueType, _Kfn, _Pr, _A> _Imp;
	typedef _Imp::size_type SizeType;
	typedef _Imp::difference_type DifferenceType;
	typedef _Imp::reference Reference;
	typedef _Imp::const_reference ConstReference;
	typedef _Imp::iterator Iterator;
	typedef _Imp::const_iterator ConstIterator;
    /*
	typedef _Imp::reverse_iterator ReverseIterator;
	typedef _Imp::const_reverse_iterator ConstReverseIterator;
    */
	typedef Pair<Iterator, BOOL> _Pairib;
	typedef Pair<Iterator, Iterator> _Pairii;
	typedef Pair<ConstIterator, ConstIterator> _Paircc;
	explicit Map(const _Pr& _Pred = _Pr(), const _A& _Al = _A())
		: _Tr(_Pred, FALSE, _Al) {}
	typedef const ValueType *_It;
    /*
	Map(_It _F, _It _L, const _Pr& _Pred = _Pr(),
		const _A& _Al = _A())
		: _Tr(_Pred, FALSE, _Al)
		{for (; _F != _L; ++_F)
			_Tr.insert(*_F); }
            */
	_Myt& operator=(const _Myt& _X)
		{_Tr = _X._Tr;
		return (*this); }
	Iterator Begin()
		{return (_Tr.begin()); }
	ConstIterator Begin() const
		{return (_Tr.begin()); }
	Iterator End()
		{return (_Tr.end()); }
	ConstIterator End() const
		{return (_Tr.end()); }
    /*
	ReverseIterator rbegin()
		{return (_Tr.rbegin()); }
	ConstReverseIterator rbegin() const
		{return (_Tr.rbegin()); }
	ReverseIterator rend()
		{return (_Tr.rend()); }
	ConstReverseIterator rend() const
		{return (_Tr.rend()); }
        */
	SizeType Size() const
		{return (_Tr.size()); }
	SizeType MaxSize() const
		{return (_Tr.max_size()); }
	BOOL Empty() const
		{return (_Tr.empty()); }
	_A GetAllocator() const
		{return (_Tr.get_allocator()); }
    /*
	_Tref operator[](const KeyType& _Kv)
		{Iterator _P = insert(ValueType(_Kv, _Ty())).first;
		return ((*_P).second); }
        */
    // If the argument key value is not found, then it is inserted along with 
    // the default value of the data type.
    // Don't need to declare a pair with this Insert or doing a cast.
    // Map[KeyType] = ReferentType;
    BOOL Assign(const KeyType& _Kv, const ReferentType& _Tyv, _Pairib& ibPair)
    {
        if(!Insert(ValueType(_Kv,  _Ty()), ibPair))
        {
            return FALSE;
        }
        ibPair.first->second = _Tyv;
        return TRUE;
    }
    BOOL Assign(const KeyType& _Kv, const ReferentType& _Tyv = _Ty())
    {
        _Pairib ibPair = _Pairib();
        return Assign(_Kv, _Tyv, ibPair);
    }
    
    // ReferentType = Map[KeyType];
    BOOL Retrieve(const KeyType& _Kv, ReferentType& _Tyv, _Pairib& ibPair)
    {
        if(!Insert(ValueType(_Kv, _Ty()), ibPair))
        {
            return FALSE;
        }
        _Tyv = ibPair.first->second;
        return TRUE;
    }
    BOOL Retrieve(const KeyType& _Kv, ReferentType& _Tyv)
    {
        _Pairib ibPair = _Pairib();
        return Retrieve(_Kv, _Tyv, ibPair);
    }
    BOOL Retrieve(const KeyType& _Kv)
    {
        ReferentType _Tyv = _Ty();
        _Pairib ibPair = _Pairib();
        return Retrieve(_Kv, _Tyv, ibPair);
    }
    
    // This one take a pair.
	BOOL Insert(const ValueType& _X, _Pairib& ibPair)
		{return _Tr.insert(_X, ibPair);}
	BOOL Insert(const ValueType& _X)
		{_Pairib ibPair = _Pairib(); return Insert(_X, ibPair);}

    // Take a position has an hint to insert and take a pair.
	BOOL Insert(Iterator _P, const ValueType& _X, Iterator& itIterator)
		{return (_Tr.insert((_Imp::iterator&)_P, _X, itIterator)); }
	BOOL Insert(Iterator _P, const ValueType& _X)
		{Iterator itIterator = Iterator(); return Insert(_P, _X, itIterator);}
	BOOL Insert(_It _F, _It _L)
    {
        for (; _F != _L; ++_F)
        {
            if(!_Tr.insert(*_F))
            {
                // if allocation failed, return FALSE.
                return FALSE;
            }
        }
        return TRUE;
    }
	Iterator Erase(Iterator _P)
		{return (_Tr.erase((_Imp::iterator&)_P)); }
	Iterator Erase(Iterator _F, Iterator _L)
		{return (_Tr.erase((_Imp::iterator&)_F,
			(_Imp::iterator&)_L)); }
	SizeType Erase(const _K& _Kv)
		{return (_Tr.erase(_Kv)); }
	void Clear()
		{_Tr.clear(); }
	void Swap(_Myt& _X)
		{Mtl::swap(_Tr, _X._Tr); }
	friend void Swap(_Myt& _X, _Myt& _Y)
		{_X.swap(_Y); }
	KeyCompare KeyComp() const
		{return (_Tr.key_comp()); }
	ValueCompare ValueComp() const
		{return (ValueCompare(_Tr.key_comp())); }
	Iterator Find(const _K& _Kv)
		{return (_Tr.find(_Kv)); }
	ConstIterator Find(const _K& _Kv) const
		{return (_Tr.find(_Kv)); }
	SizeType Count(const _K& _Kv) const
		{return (_Tr.count(_Kv)); }
	Iterator LowerBound(const _K& _Kv)
		{return (_Tr.lower_bound(_Kv)); }
	ConstIterator LowerBound(const _K& _Kv) const
		{return (_Tr.lower_bound(_Kv)); }
	Iterator UpperBound(const _K& _Kv)
		{return (_Tr.upper_bound(_Kv)); }
	ConstIterator UpperBound(const _K& _Kv) const
		{return (_Tr.upper_bound(_Kv)); }
	_Pairii EqualRange(const _K& _Kv)
		{return (_Tr.equal_range(_Kv)); }
	_Paircc EqualRange(const _K& _Kv) const
		{return (_Tr.equal_range(_Kv)); }
protected:
	_Imp _Tr;
	};
		// Map TEMPLATE OPERATORS
template<class _K, class _Ty, class _Pr, class _A> inline
	BOOL operator==(const Map<_K, _Ty, _Pr, _A>& _X,
		const Map<_K, _Ty, _Pr, _A>& _Y)
	{return (_X.Size() == _Y.Size()
		&& equal(_X.Begin(), _X.End(), _Y.Begin())); }
template<class _K, class _Ty, class _Pr, class _A> inline
	BOOL operator!=(const Map<_K, _Ty, _Pr, _A>& _X,
		const Map<_K, _Ty, _Pr, _A>& _Y)
	{return (!(_X == _Y)); }
template<class _K, class _Ty, class _Pr, class _A> inline
	BOOL operator<(const Map<_K, _Ty, _Pr, _A>& _X,
		const Map<_K, _Ty, _Pr, _A>& _Y)
	{return (lexicographical_compare(_X.Begin(), _X.End(),
		_Y.Begin(), _Y.End())); }
template<class _K, class _Ty, class _Pr, class _A> inline
	BOOL operator>(const Map<_K, _Ty, _Pr, _A>& _X,
		const Map<_K, _Ty, _Pr, _A>& _Y)
	{return (_Y < _X); }
template<class _K, class _Ty, class _Pr, class _A> inline
	BOOL operator<=(const Map<_K, _Ty, _Pr, _A>& _X,
		const Map<_K, _Ty, _Pr, _A>& _Y)
	{return (!(_Y < _X)); }
template<class _K, class _Ty, class _Pr, class _A> inline
	BOOL operator>=(const Map<_K, _Ty, _Pr, _A>& _X,
		const Map<_K, _Ty, _Pr, _A>& _Y)
	{return (!(_X < _Y)); }
/*
		// TEMPLATE CLASS multimap
template<class _K, class _Ty, class _Pr = less<_K>,
	class _A = allocator<_Ty> >
	class multimap {
public:
	typedef multimap<_K, _Ty, _Pr, _A> _Myt;
	typedef Pair<const _K, _Ty> ValueType;
	struct _Kfn : public unary_function<ValueType, _K> {
		const _K& operator()(const ValueType& _X) const
		{return (_X.first); }
		};
	class ValueCompare
		: public binary_function<ValueType, ValueType, BOOL> {
		friend class Map<_K, _Ty, _Pr, _A>;
	public:
		BOOL operator()(const ValueType& _X,
			const ValueType& _Y) const
			{return (comp(_X.first, _Y.first)); }
	_PROTECTED:
		ValueCompare(_Pr _Pred)
			: comp(_Pred) {}
		_Pr comp;
		};
	typedef _K KeyType;
	typedef _Ty ReferentType;
	typedef _Pr KeyCompare;
	typedef _A AllocatorType;
	typedef _Tree<_K, ValueType, _Kfn, _Pr, _A> _Imp;
	typedef _Imp::size_type SizeType;
	typedef _Imp::difference_type DifferenceType;
	typedef _Imp::reference Reference;
	typedef _Imp::const_reference ConstReference;
	typedef _Imp::iterator Iterator;
	typedef _Imp::const_iterator ConstIterator;
	typedef _Imp::reverse_iterator ReverseIterator;
	typedef _Imp::const_reverse_iterator ConstReverseIterator;
	typedef Pair<Iterator, Iterator> _Pairii;
	typedef Pair<ConstIterator, ConstIterator> _Paircc;
	explicit multimap(const _Pr& _Pred = _Pr(),
		const _A& _Al = _A())
		: _Tr(_Pred, TRUE, _Al) {}
	typedef const ValueType *_It;
	multimap(_It _F, _It _L, const _Pr& _Pred = _Pr(),
			const _A& _Al = _A())
		: _Tr(_Pred, TRUE, _Al)
		{for (; _F != _L; ++_F)
			_Tr.insert(*_F); }
	_Myt& operator=(const _Myt& _X)
		{_Tr = _X._Tr;
		return (*this); }
	Iterator begin()
		{return (_Tr.begin()); }
	ConstIterator begin() const
		{return (_Tr.begin()); }
	Iterator end()
		{return (_Tr.end()); }
	ConstIterator end() const
		{return (_Tr.end()); }
	ReverseIterator rbegin()
		{return (_Tr.rbegin()); }
	ConstReverseIterator rbegin() const
		{return (_Tr.rbegin()); }
	ReverseIterator rend()
		{return (_Tr.rend()); }
	ConstReverseIterator rend() const
		{return (_Tr.rend()); }
	SizeType size() const
		{return (_Tr.size()); }
	SizeType max_size() const
		{return (_Tr.max_size()); }
	BOOL empty() const
		{return (_Tr.empty()); }
	_A get_allocator() const
		{return (_Tr.get_allocator()); }
	Iterator insert(const ValueType& _X)
		{return (_Tr.insert(_X).first); }
	Iterator insert(Iterator _P, const ValueType& _X)
		{return (_Tr.insert((_Imp::iterator&)_P, _X)); }
	void insert(_It _F, _It _L)
		{for (; _F != _L; ++_F)
			_Tr.insert(*_F); }
	Iterator erase(Iterator _P)
		{return (_Tr.erase((_Imp::iterator&)_P)); }
	Iterator erase(Iterator _F, Iterator _L)
		{return (_Tr.erase((_Imp::iterator&)_F,
			(_Imp::iterator&)_L)); }
	SizeType erase(const _K& _Kv = _K())
		{return (_Tr.erase(_Kv)); }
	void clear()
		{_Tr.clear(); }
	void swap(_Myt& _X)
		{Mtl::swap(_Tr, _X._Tr); }
	friend void swap(_Myt& _X, _Myt& _Y)
		{_X.swap(_Y); }
	KeyCompare key_comp() const
		{return (_Tr.key_comp()); }
	ValueCompare value_comp() const
		{return (ValueCompare(_Tr.key_comp())); }
	Iterator find(const _K& _Kv)
		{return (_Tr.find(_Kv)); }
	ConstIterator find(const _K& _Kv) const
		{return (_Tr.find(_Kv)); }
	SizeType count(const _K& _Kv) const
		{return (_Tr.count(_Kv)); }
	Iterator lower_bound(const _K& _Kv)
		{return (_Tr.lower_bound(_Kv)); }
	ConstIterator lower_bound(const _K& _Kv) const
		{return (_Tr.lower_bound(_Kv)); }
	Iterator upper_bound(const _K& _Kv)
		{return (_Tr.upper_bound(_Kv)); }
	ConstIterator upper_bound(const _K& _Kv) const
		{return (_Tr.upper_bound(_Kv)); }
	_Pairii equal_range(const _K& _Kv)
		{return (_Tr.equal_range(_Kv)); }
	_Paircc equal_range(const _K& _Kv) const
		{return (_Tr.equal_range(_Kv)); }
protected:
	_Imp _Tr;
	};
		// multimap TEMPLATE OPERATORS
template<class _K, class _Ty, class _Pr, class _A> inline
	BOOL operator==(const multimap<_K, _Ty, _Pr, _A>& _X,
		const multimap<_K, _Ty, _Pr, _A>& _Y)
	{return (_X.size() == _Y.size()
		&& equal(_X.begin(), _X.end(), _Y.begin())); }
template<class _K, class _Ty, class _Pr, class _A> inline
	BOOL operator!=(const multimap<_K, _Ty, _Pr, _A>& _X,
		const multimap<_K, _Ty, _Pr, _A>& _Y)
	{return (!(_X == _Y)); }
template<class _K, class _Ty, class _Pr, class _A> inline
	BOOL operator<(const multimap<_K, _Ty, _Pr, _A>& _X,
		const multimap<_K, _Ty, _Pr, _A>& _Y)
	{return (lexicographical_compare(_X.begin(), _X.end(),
		_Y.begin(), _Y.end())); }
template<class _K, class _Ty, class _Pr, class _A> inline
	BOOL operator>(const multimap<_K, _Ty, _Pr, _A>& _X,
		const multimap<_K, _Ty, _Pr, _A>& _Y)
	{return (_Y < _X); }
template<class _K, class _Ty, class _Pr, class _A> inline
	BOOL operator<=(const multimap<_K, _Ty, _Pr, _A>& _X,
		const multimap<_K, _Ty, _Pr, _A>& _Y)
	{return (!(_Y < _X)); }
template<class _K, class _Ty, class _Pr, class _A> inline
	BOOL operator>=(const multimap<_K, _Ty, _Pr, _A>& _X,
		const multimap<_K, _Ty, _Pr, _A>& _Y)
	{return (!(_X < _Y)); }
*/
MTLEND

#endif /* _MTLMAP_ */

/*
 * Copyright (c) 1995 by P.J. Plauger.  ALL RIGHTS RESERVED. 
 * Consult your license regarding permissions and restrictions.
 */

/*
 * This file is derived from software bearing the following
 * restrictions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Permission to use, copy, modify, distribute and sell this
 * software and its documentation for any purpose is hereby
 * granted without fee, provided that the above copyright notice
 * appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation.
 * Hewlett-Packard Company makes no representations about the
 * suitability of this software for any purpose. It is provided
 * "as is" without express or implied warranty.
 */
