 /***************************************************************************\
|*                                                                           *|
|*       Copyright 2002 Matrox Graphics Inc. All rights reserved.            *|
|*                                                                           *|
|*     NOTICE TO THE USER: This source code is the copyrighted work of       *| 
|*     Matrox. Users of this source code are hereby granted a nonexclusive,  *|
|*     royalty-free copyright license to use this code in individual and     *| 
|*     commercial software.                                                  *|
|*                                                                           *|
|*     Any use of this source code must include, in the user documenta-      *|
|*     tion and internal comments to the code, notices to the end user       *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 2002 Matrox Graphics Inc. All rights reserved.            *|
|*                                                                           *|
|*     The source code is provided to you AS IS and WITH ALL FAULTS. Matrox  *|
|*     makes no representation and gives no warranty whatsoever, whether     *|
|*     express or implied, and without limitation, with regard to the        *|
|*     quality, safety, contents, performance, merchantability, non-         *|
|*     infringement or suitability for any particular or intended purpose    *|
|*     of this source code. In no event will Matrox be liable for any        *|
|*     direct, indirect, punitive, special, incidental or consequential      *|
|*     damages however they may arise and even if Matrox has been previously *|
|*     advised of the possibility of such damages.                           *|
|*                                                                           *|
 \***************************************************************************/
/***************************************************************************************\

Module Name:    SharedData.h

Description:    This module contains the SharedData and SharedLocked data structure 
                definitions. These structure is meant to share information between the 
                driver and the miniport.

References:   	


    Copyright (C) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_SHAREDDATAOS_H
#define INC_SHAREDDATAOS_H

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------
// Maximum output supported
#define MAX_NB_OUTPUTS              2

// Maximum CRTC supported
#define MAX_NB_CRTCS                MAX_NB_OUTPUTS

// Maximum CRTC supported
#define NBR_OF_UNIT                 MAX_NB_OUTPUTS

// Maximum controller supported
#define MAX_NB_CONTROLLERS          4

// Maximum number of host decriptors (XXX: Same as HwDevice::HOST_DESC_COUNT)
#define MAX_NB_HOST_DESCRIPTORS     20

/***************************************************************************************\

Class:          InterlockedFn

Description:    This structure conmtains pointers to the synchronization functions
                taken from the miniport to be used in the driver.

Comments:       None.

\***************************************************************************************/
#if 0
struct InterlockedFn
{
    LONG (FASTCALL *pfnExchange)(IN OUT PLONG, IN LONG);
    LONG (FASTCALL *pfnIncrement)(IN OUT PLONG);
    LONG (FASTCALL *pfnDecrement)(IN OUT PLONG);
};
#endif

/***************************************************************************************\

Class:          SDwgMarkData

Description:    This structure contains data written by the hardware on a 
                DwgMark write, plus some other useful data related to it.

Comments:       None.

\***************************************************************************************/
typedef struct
{
    volatile DWORD  m_dwPrimAddrValue;  // Current value of DMA_PRIMPTR written by hardware
    volatile DWORD  m_dwReserved1;      // Those are unused values written by hardware
    volatile DWORD  m_dwReserved2;      
    volatile DWORD  m_dwReserved3;
    volatile DWORD  m_dwHwTagValue;     // Synchronization information written by hardware
    volatile DWORD  m_dwReserved4;      // Those are unused values written by hardware
    volatile DWORD  m_dwReserved5;
    volatile DWORD  m_dwReserved6;
    
    DWORD           m_dwPhysAddress;    // Physical address of the DwgMarkData object
    DWORD           m_dwLastValue;      // Last value sent to the hardware

} SDwgMarkData;

/***************************************************************************************\

Class:          SDmaSyncData

Description:    This structure contains data written by the hardware on a 
                DmaSync write, plus some other useful data related to it.

Comments:       None.

\***************************************************************************************/
typedef struct
{
    volatile DWORD  m_dwHwTagValue;     // Current value of DMA_SYNC written by hardware
    volatile DWORD  m_dwReserved1;      // Those are unused values written by hardware
    volatile DWORD  m_dwReserved2;
    volatile DWORD  m_dwReserved3;

    // Note: The following members have to be volatile to avoid problems on 
    //        AMD processors with SIS and ALI chipsets (one cache line of 32 bytes).
    volatile DWORD  m_dwPhysAddress;    // Physical address of this data
    volatile ULONG  m_dwLastValue;      // Last value sent to the hardware
    volatile DWORD  m_dwPadding1;       // Padding so object size is a multiple of a QUADWORD
    volatile DWORD  m_dwPadding2;

} SDmaSyncData;

/***************************************************************************************\

Class:          SHwMemoryMapData

Description:    This structure contains data about board video memory.

Comments:       None.

\***************************************************************************************/
typedef struct
{
    DWORD       m_dwPciPhysical;
    DWORD       m_dwPciSize;
    DWORD       m_dwSizeAB;
    DWORD       m_dwSizeCD;
    MEMHANDLE   m_pvSimLinear;
    DWORD       m_dwSimPhysical;
    DWORD       m_dwSimSize;

} SHwMemoryMapData;

/***************************************************************************************\

Class:          SHwRegisterMapData

Description:    This structure contains data about board control registers memory.

Comments:       None.

\***************************************************************************************/
typedef struct
{
    // Parhelia registers
    DWORD       m_dwPhysical;
    DWORD       m_dwSize;

    // Emulator registers
    MEMHANDLE   m_pvSimLinear;
    DWORD       m_dwSimPhysical;
    DWORD       m_dwSimSize;

} SHwRegisterMapData;

/***************************************************************************************\

Class:          SHwRegAccessData

Description:    This structure contains data about control registers accesses.

Comments:       None.

\***************************************************************************************/
typedef struct
{
    DWORD dwLastDwgCtlRegister;
    DWORD dwDirectAccessCount;
    DWORD dwGenIenRegister;          // Patch for EAR 350: Keep the GEN_IEN register value.
    
} SHwRegAccessData;

/***************************************************************************************\

Class:          SHwEngineOwnerData

Description:    This structure contains data about current owner of the board
                drawing engine.

Comments:       None.

\***************************************************************************************/
enum
{
    OWNER_NOBODY = 0,
    OWNER_DISPLAYDRIVER,
    OWNER_DIRECTDRAW,
    OWNER_DIRECT3D,
    OWNER_OPENGL,
    OWNER_PRESCALE_DRV,
    OWNER_PRESCALE_MINI,
};

typedef struct
{
    DWORD     m_eOwnerId;
    DWORD_PTR m_dwOwnerContext;
    
} SHwEngineOwnerData;

/***************************************************************************************\

Class:          SHostDescData

Description:    This structure contains data about host descriptor registers on
                the board.

Comments:       None.

\***************************************************************************************/
enum
{
    HOSTDESC_SRFADDR_INVALID      = 0x00000001,
    HOSTDESC_MAPPER_INVALID       = 0xFFFFFFFF,

    HOSTDESC_STATE_INVALID        = 0x00000001,
    HOSTDESC_STATE_LOCKED         = 0x00000002,
    HOSTDESC_STATE_PERMANENT      = 0x00000004,

    HOSTDESC_DESCRIPTORS_COUNT    = MAX_NB_HOST_DESCRIPTORS,
};

typedef struct
{
    DWORD m_dwMapperId;         // Unique ID of surface mapper that owns this descriptor
    DWORD m_dwState;            // Current state of this descriptor

    ULONG m_ulRefCount;         // Number of aperture referring to this descriptor
    
    DWORD m_dwSrfAddr;          // Content of HST_SURFADDR
    DWORD m_dwSrfMode;          // Content of HST_SURFMODE
    DWORD m_dwSrfDim;           // Content of HST_SURFDIM
    ULONG m_ulLastAddress;      // Last PCI address used by this descriptor
    
} SHostDescData;


/***************************************************************************************\

Class:          SharedLockedData

Description:    Shares data between the miniport and the driver. This structure is in 
                locked memory so it's safe to access it in an interrupt.

Comments:       None.

\***************************************************************************************/
typedef struct SharedLockedData_t
{
    // Pointers to data written by engine for DMASYNC and DWGMARK
    // Note: These object's contructors are never actually called since
    //       this structure is not allocated normally.
    SDwgMarkData     oDwgMarkData;
    // The next structure must be aligned on 32 bytes (one cache line).
    BYTE             abyPadding[(32 - (sizeof(SDwgMarkData) & 0x1F)) & 0x1F];
    SDmaSyncData     oDmaSyncData;

    // Size and Physical address of this structure (set by miniport upon creation)
    ULONG       ulSize;
    DWORD       dwPhysicalAddress;

    // Last valid PRIMEND value to use when restarting the busmastering
    DWORD       dwLastPrimendValue;

    // Number of pending softraps in the DMA
    ULONG       ulPendingSoftraps;

    // This contains interrupt commands (SOFTRAP, DWGMARK)
//    BmIntCmdLoop*   poIntCmdLoop;

    // The board handle from the HAL.
//    BOARDHANDLE     oBoard;

    // Synchronization functions
//    InterlockedFn   oInterlockedFn;

    // Drawing engine mutex. Before to do any drawing engine programming, we must 
    // grab this mutex and then release it after.
    volatile BOOL bDwgMutex;

    // Hardware register access data.
    volatile BYTE oHwRegAccessData[sizeof(SHwRegAccessData)];

    // Hardware memory and register aperture data.
    BYTE  oHwMemoryMapData[sizeof(SHwMemoryMapData)];
    BYTE  oHwRegisterMapData[sizeof(SHwRegisterMapData)];

    // Engine Owner synchronization object.
    SHwEngineOwnerData oHwEngineOwnerData;

    // Current host descriptors configuration and interface enable count
    SHostDescData aoHostDescriptors[MAX_NB_HOST_DESCRIPTORS];

    // Mutex to lock host descriptor table (for surface mappers)
    MUTEX  oHostInterfaceMutex;

    // Mutex to lock the VPE. (Used by MES Video).
//    MUTEX   VpeLockMutex;

    // Mutex to lock the CTRC2
//    MUTEX   Crtc2LockMutex;

    // Mutex for desktop pre-scale protection.
//    MUTEX   oDesktopPreScaleMutex;
    
    // Desktop Pre-scale settings pointer.
//    CDPSManager*    pdpsManager;
    
    // Index controllers for flipping the primary
//    DisplayIndexController::SCommon aoDisplayIndexControllerData[MAX_NB_OUTPUTS];
    
    // Data used by bus mastering tests
//    SAgpInfo oAgpInfo;

} SharedLockedData;

/***************************************************************************************\

Class:          SharedData

Description:    Shares data between the miniport and the driver. Do NOT use this 
                structure in an interrupt handler use SharedLockedData.


Comments:       None.

\***************************************************************************************/
typedef struct SharedData_t 
{
    // Size and Physical address of this structure (set by miniport upon creation)
    ULONG       ulSize;
    DWORD       dwPhysicalAddress;
    
} SharedData;

/***************************************************************************************\

Class:       SCommonMemAllocInfo

Description: Structure for tracking allocation of common memory (memory that is
             simultaneously accessible from both the processor and a device for
             common-buffer DMA operations).

Comments:    None.

\***************************************************************************************/

#ifndef PHYSICAL_ADDRESS
  typedef LARGE_INTEGER PHYSICAL_ADDRESS, *PPHYSICAL_ADDRESS;
#endif

typedef struct
{
    ULONG            ulSizeInBytes;
    void*            VirtualAddress;
    PHYSICAL_ADDRESS LogicalAddress;
} SCommonMemAllocInfo;

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_SHAREDDATA_H
