 /***************************************************************************\
|*                                                                           *|
|*       Copyright 2002 Matrox Graphics Inc. All rights reserved.            *|
|*                                                                           *|
|*     NOTICE TO THE USER: This source code is the copyrighted work of       *| 
|*     Matrox. Users of this source code are hereby granted a nonexclusive,  *|
|*     royalty-free copyright license to use this code in individual and     *| 
|*     commercial software.                                                  *|
|*                                                                           *|
|*     Any use of this source code must include, in the user documenta-      *|
|*     tion and internal comments to the code, notices to the end user       *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 2002 Matrox Graphics Inc. All rights reserved.            *|
|*                                                                           *|
|*     The source code is provided to you AS IS and WITH ALL FAULTS. Matrox  *|
|*     makes no representation and gives no warranty whatsoever, whether     *|
|*     express or implied, and without limitation, with regard to the        *|
|*     quality, safety, contents, performance, merchantability, non-         *|
|*     infringement or suitability for any particular or intended purpose    *|
|*     of this source code. In no event will Matrox be liable for any        *|
|*     direct, indirect, punitive, special, incidental or consequential      *|
|*     damages however they may arise and even if Matrox has been previously *|
|*     advised of the possibility of such damages.                           *|
|*                                                                           *|
 \***************************************************************************/
/***************************************************************************************\

File Name:      MtxParhl.h

Description:    MTX Parhelia device driver interface. This can be included by
                any applications that want to run a PARHELIA512 board through the
                MTX driver.

References:     None.

Author:         Karl Lessard    <klessard@matrox.com>

    Copyright (c) 2002, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXPARHELIA_H
#define INC_MTXPARHELIA_H

/*******************************************
 *
 * Included headers
 *
 ******************************************/

#include "mtx.h"
#include "ParhlTypes.h"

/******************************************
 *
 * Constants and types
 *
 *****************************************/

#define MTX_PARHL_INVALID_ADDRESS   0xFFFFFFFF

typedef enum {
    
    MMSURF_DATA_DISPLAY,
    MMSURF_DATA_BMBUFFER,

    MMSURF_DATA_DISPLAY_PRIMARY,
    MMSURF_DATA_NONDISPLAY_PRIMARY,
 
    MMSURF_DATA_3D_ZBUFFER,
    MMSURF_DATA_3D_INTENSITY,
    MMSURF_DATA_3D_DISPLAY_INTENSITY,
    MMSURF_DATA_3D_FRAGMENT,
    MMSURF_DATA_3D_TEXTURE,
    MMSURF_DATA_3D_TEXTURE_TEXTILED,

    MMSURF_DATA_DD_GENERIC,
    MMSURF_DATA_DD_OVERLAY,
    MMSURF_DATA_DD_SRCOVERLAY,

    MMSURF_DATA_2D_DEVICE_BITMAP,
    MMSURF_DATA_2D_SURFACE,
    MMSURF_DATA_2D_MONO_SURFACE,
    MMSURF_DATA_2D_CURSOR,
    
    MMSURF_DATA_2D_AB_ONLY,
    MMSURF_DATA_2D_AB_FIRST,
    MMSURF_DATA_2D_CD_ONLY,
    MMSURF_DATA_2D_CD_FIRST,
    
    MMSURF_DATA_COUNT,
    MMSURF_DATA_INVALID,
    
} MmSurfaceDataType;

typedef enum {
    
    MMSURF_MEM_LOCAL,
    MMSURF_MEM_LOCAL_COMMON,
    MMSURF_MEM_GEN_AGP,
    MMSURF_MEM_PCI_LOCKED,
    MMSURF_MEM_USER_MEM,
    MMSURF_MEM_LOCAL_LIN,
    MMSURF_MEM_DX_AGP,

    MMSURF_MEM_COUNT,
    MMSURF_MEM_INVALID,
    
} MmSurfaceMemType;

typedef enum {
    
    MMSURF_PRIO_PERMANENT   =  0,
    MMSURF_PRIO_DISCARDABLE =  1
        
} MmSurfacePriority;

typedef enum {
    
    APT_PRIO_PERMANENT   =  0,
    APT_PRIO_DISCARDABLE =  1
        
} AperturePriority;

/*
 * mtx_parhl_block_type
 *
 * Type of block for allocation
 */
typedef enum {
   
    MTX_PARHL_BLOCKTYPE_SURFACE,                /* Surface memory block */
    MTX_PARHL_BLOCKTYPE_APERTURE,               /* Aperture memory block */

    MTX_PARHL_BLOCKTYPE_COUNT,
 
    MTX_PARHL_BLOCKTYPE_TYPE_MASK = 0x7FFFFFFF,
    MTX_PARHL_BLOCKTYPE_SHARED = 0x80000000,    /* Set this flag if block is sharable */

} MtxParhlBlockType;


/******************************************
 *
 * IOCTL data structures
 *
 *****************************************/

/*
 * MtxParhlIoctlAllocBlock
 *
 * structure used as input/output data for 
 * parhelia's alloc_block I/O control.
 */
typedef struct mtx_parhl_ioctl_alloc_block {

    ULONG   ulBase;     /* physical address (returned by kernel) */
    ULONG   ulSize;     /* size of block (real size returned by kernel) */
    ULONG   ulOffset;   /* offset in memory heap (returned by kernel) */

    ULONG   ulType;     /* type of block */

    union {

        struct {
            
            MmSurfaceDataType   eDataType;  /* data intended to be stored in this block */
            MmSurfaceMemType    eMemType;   /* type of memory for this block */
            MmSurfacePriority   ePriority;  /* priority of this allocation */
            
        } Surf;

        struct {

            ULONG            ulIndex;       /* Index descriptor used for this aperture (returned) */
            ULONG            ulStartAddress;/* block start address, or invalid if any will do */
            AperturePriority ePriority;     /* priority of this allocation */

        } Apt;

    } Options;
        
} MtxParhlIoctlBufferAllocBlock;

/*
 * MtxParhlIoctlMemoryLayout
 * 
 * this structure is used to pass information
 * to an application about the layout of
 * parhelia's local memory
 */
typedef struct mtx_parhl_ioctl_local_memory_layout {

    ULONG   ulABStart;
    ULONG   ulABSize;
    
    ULONG   ulCDStart;
    ULONG   ulCDSize;
    
    ULONG   ulCommonABStart;
    ULONG   ulCommonABSize;

    ULONG   ulCommonCDStart;
    ULONG   ulCommonCDSize;

    ULONG   ulLinearStart;
    ULONG   ulLinearSize;

} MtxParhlIoctlBufferLocalMemoryLayout;


/******************************************
 *
 * I/O controls
 *
 *****************************************/

/* I/O controls specific to parhelia boards */
#define MTX_PARHL_IOCTL_MAXNR           0x02

#define MTX_PARHL_IOCTL_ALLOC_BLOCK     \
    MTX_IOWR(0x00, MTX_PARHL_IOCTL_NROFF, MtxParhlIoctlBufferAllocBlock)
#define MTX_PARHL_IOCTL_FREE_BLOCK      \
    MTX_IOW(0x01, MTX_PARHL_IOCTL_NROFF, MtxParhlIoctlBufferAllocBlock)
#define MTX_PARHL_IOCTL_GET_LOCAL_MEMORY_LAYOUT \
    MTX_IOR(0x02, MTX_PARHL_IOCTL_NROFF, MtxParhlIoctlBufferLocalMemoryLayout)
    
#endif  // #ifndef INC_MTXPARHELIA_H
