#!/bin/sh

#Uncomment the next line for testing
#set -x 

#====================================================
#
#  Matrox Driver Install Script
#
#  Copyright (C) 2001, Matrox Graphics Inc.
#
#  Author : Karl Lessard
#  Last modified : August 2002 by Luugi Marsan
#====================================================

VMAJOR=0
VMINOR=2
VPATCH=0

clear
echo ""
echo "Matrox Driver Installation Script"

ROOT=
restartX=0
undo=0
BCK_SFFX=".mtxbck.$VMAJOR.$VMINOR.$VPATCH"

# check for superuser mode
if ! test -r /proc/kmsg ; then
    echo ""
    echo "Error: You must be logged in as Root to run this program. Exiting."
    echo ""
    exit 1
fi
    

# parsing options

n=$#
i=0
for arg in $* ; do
    param=`echo $arg | cut -d'=' -f1`
    value=`echo $arg | cut -d'=' -f2`
    case $param in
        "root") ROOT=$value ;;
        "restore") undo=1 ;;
    esac;
done

# check X version
Xpresent=0
Xpath=`which X 2> /dev/null`
#check if there's an X server
if [ $? -eq 1 ] ; then
    echo ""
    echo "Warning: No X server found."
    echo ""
else
    WHEREIS=`whereis X 2> /dev/null`
    #let's use grep for doing the search
    field=`echo $WHEREIS | grep -s '/usr/X11R6/bin/X'`
    #if we find it
    if [ $? -eq 0 ] ; then
        Xpath="/usr/X11R6"
    else
        echo ""
        echo "Please enter the full path to your current X11R6 directory: "
        echo "Example: /usr/X11R6"
        read Xpath
    fi
fi
        
Xpath=$ROOT$Xpath

#determine kernel module install directory
VERSION=`uname -r` 
KERNELMODDIR=/lib/modules/$VERSION
#set install directory
if test -d $KERNELMODDIR/kernel; then
    INSTALLDIR=$KERNELMODDIR/kernel/drivers/video
else
    INSTALLDIR=$KERNELMODDIR/video
fi

#determine XFree86 Version
Xversion=`X -version 2>&1 | grep -s "XFree86 Version" | cut -d" " -f3 | sed -e "s/\([^\.]*\.[^\.]*\.[^\.]*\)\.[^\.]*/\1/"`

if ! test -e ./xfree86/$Xversion ; then
    echo "Warning: The XFree86 drivers included in this installation package"
    echo "do not support your version of XFree86."
    echo ""
else
    Xpresent=1
fi


# RESTORE MODE: restoring backup files

if [ $undo -eq 1 ] ; then
    restoreX=0
    restartX=0
    restoreParhl=0
    removeParhl=0
    restoreMtx=0
    removeMtx=0

    echo ""
    echo "You are about to restore your previous display drivers."
    echo -n "Press [Enter] to continue, or any other key to cancel. "
    read -n 1 reallyundo
    if [ ! -z $reallyundo ] ; then
        echo ""
        echo ""
        echo "Restore cancelled. Exiting."
        echo ""
        exit 0
    fi
    if test -e $Xpath/lib/modules/drivers/mtx_drv.o$BCK_SFFX; then
        echo ""
        echo -n "Restore XFree86 mtx driver (y/n)? "
        read str_restoreX
        if [ $str_restoreX = 'Y' -o $str_restoreX = 'y' ] ; then 
            mv -f $Xpath/lib/modules/drivers/mtx_drv.o$BCK_SFFX $Xpath/lib/modules/drivers/mtx_drv.o
            restoreX=1
            restartX=1
        fi
    fi
    if test -e /usr/lib/libparhl.so$BCK_SFFX; then
        echo ""
        echo -n "Restore Parhelia library (y/n)? "
        read str_restoreParhl
        if [ $str_restoreParhl = 'Y' -o $str_restoreParhl = 'y' ] ; then 
            mv -f /usr/lib/libparhl.so$BCK_SFFX /usr/lib/libparhl.so
            restoreParhl=1
            restartX=1
        fi
    elif test -e /usr/lib/libparhl.so; then
        echo ""
        echo -n "Remove Parhelia library (y/n)? "
        read str_removeParhl
        if [ $str_removeParhl = 'Y' -o $str_removeParhl = 'y' ] ; then
            rm -f /usr/lib/libparhl.so
            rm -f $Xpath/lib/modules/linux/libparhl.so
            removeParhl=1
            restartX=1
        fi
    fi

    if test -e $INSTALLDIR/mtx.o$BCK_SFFX; then
        echo ""
        echo -n "Restore Matrox kernel module (y/n)? "
        read str_restoreParhl
        if [ $str_restoreMtx = 'Y' -o $str_restoreMtx = 'y' ] ; then 
            mv -f $INSTALLDIR/mtx.o$BCK_SFFX $INSTALLDIR/mtx.o
            restoreMtx=1
            restartX=1
        fi
    elif test -e $INSTALLDIR/mtx.o; then
        echo ""
        echo -n "Remove Matrox kernel module (y/n)? "
        read str_removeMtx
        if [ $str_removeMtx = 'Y' -o $str_removeMtx = 'y' ] ; then
            rm -f /$INSTALLDIR/mtx.o
            removeMtx=1
            restartX=1
        fi
    fi
    echo ""
    echo "==========================================================================="
    echo ""
    echo "Summary:"
    echo ""

    echo -n "XFree86 driver:          "
    if [ $restoreX -eq 1 ] ; then echo "Restored."
    else echo "No changes made."
    fi
    
    echo -n "Parhl library:           "
    if [ $restoreParhl -eq 1 ] ; then echo "Restored."
    elif [ $removeParhl -eq 1 ] ; then echo "Removed."
    else echo "No changes made."
    fi
    
    echo -n "Mtx kernel module:       "
    if [ $restoreMtx -eq 1 ] ; then echo "Restored."
    elif [ $removeMtx -eq 1 ] ; then echo "Removed."
    else echo "No changes made."
    fi

    echo ""
    if [ $restartX -eq 1 ] ; then
        echo "You must restart the X server for changes to take effect."
    fi
    echo ""
    exit 0
fi


# NORMAL MODE: installing components

echo ""
echo "Welcome to the Matrox driver installation script. This program "
echo "will update your system with the latest Parhelia drivers for   "
echo "Linux and XFree86.                                             " 
echo ""
echo "Press any key to continue."

read -n 1

echo ""

clear


# X server driver

diffX=0
installX=0
if test -e ./xfree86/$Xversion/mtx_drv.o ; then
    diff ./xfree86/$Xversion/mtx_drv.o $Xpath/lib/modules/drivers/mtx_drv.o > /dev/null 2>&1 
    if [ $? -ne 0 ] ; then
        diffX=1
    fi
fi

echo "==============================================================="
echo ""
echo "XFree86 Parhelia 512 Driver (mtx_drv.o)"
echo ""
echo "This is the XFree86 driver. This driver is necessary "
echo "to run the XF86 server with a Parhelia card."
echo ""
if [ $diffX -eq 1 -a $Xpresent -eq 1 ] ; then
    echo -n "Install mtx XFree86 driver (y/n)? "

    read str_installX

    echo ""

    if [ $str_installX ] ; then
        if [ $str_installX = 'Y' -o $str_installX = 'y' ] ; then
            installX=1
            echo -n "Installing mtx_drv.o..."
            rm $Xpath/lib/modules/drivers/mtx_drv.o.mtxbck.* > /dev/null 2>&1
            install -m 775 -S $BCK_SFFX -b ./xfree86/$Xversion/mtx_drv.o $Xpath/lib/modules/drivers
            echo "done."
            restartX=1
        else
            installX=0
        fi
    else
        installX=0
    fi
else 
    echo "There's no need to install the XFree86 driver."
    echo "It's already up to date"
    echo ""
fi

echo "Press any key to continue"
read -n 1
clear

# Parhl lib

diffParhl=0
installParhl=0
if test -e ./lib/libparhl.so ; then
    diff ./lib/libparhl.so /usr/lib/libparhl.so > /dev/null 2>&1 
    if [ $? -ne 0 ] ; then
        diffParhl=1
    fi
fi

echo "==========================================================================="
echo ""
echo "Matrox Parhelia device driver for Linux (libparhl.so, mtx.o)"
echo ""
echo "The device driver supports bus mastering and other hardware acceleration"
echo "features on a Linux system."
echo ""
if [ $diffParhl -eq 1 ] ; then
    echo -n "Install Matrox Parhelia library (y/n)? "
    read str_installParhl

    echo ""
    if [ $str_installParhl ] ; then
        if [ $str_installParhl = 'Y' -o $str_installParhl = 'y' ] ; then
            installParhl=1
            echo -n "Installing libparhl.so..."
            rm /usr/lib/libparhl.so.mtxbck.* > /dev/null 2>&1
            install -m 775 -S $BCK_SFFX -b ./lib/libparhl.so /usr/lib/libparhl.so
            if [ $Xpresent -eq 1 ]; then
                rm $Xpath/lib/modules/linux/libparhl.so > /dev/null 2>&1
                
                ln -s /usr/lib/libparhl.so $Xpath/lib/modules/linux/libparhl.so
            fi
            echo "done."
            restartX=1
        else
            installParhl=0
        fi
    else
        installParhl=0
    fi
    echo ""
else
    echo "There's no need to install the Parhelia library"
    echo "It's already up to date"
fi

# Kernel module
diffMtx=0
installMtx=0


#Let's check if it's a know kernel version
SUPPORTEDVERSIONS=`ls kernel/binaries -1`
BINARYPATH="./kernel/src"
VERSION=`uname -r`
supportedkernel=0
failedcompilation=0
compileMtx=0
distver=`grep "Red Hat" /etc/issue | tr -d "a-zA-Z() "`

KERNEL_TYPE=`uname -r | tr -d "0-9.-"`
KERNEL_VERSION=`uname -r | tr -d "a-zA-Z"`
KERNEL_PACKAGE=kernel

for i in $SUPPORTEDVERSIONS; do
    if [ $VERSION = $i ]; then
        #Supported kernel version
        BINARYPATH="./kernel/binaries/$i"
        if [ $distver = "7.3" ]; then
            supportedkernel=1
        elif [ $distver = "7.2" ]; then
            supportedkernel=1
        elif [ $distver = "8.0" ]; then
            supportedkernel=1
        fi
    fi
done
 

#check if it's a different version
if  test -e $BINARYPATH/mtx.o ; then
    diff $BINARYPATH/mtx.o $INSTALLDIR/mtx.o > /dev/null 2>&1
    if [ $? -ne 0 ] ; then
        diffMtx=1
    fi
else
    #declare it to be an unsupported kernel
    supportedkernel=0
    diffMtx=1
fi

if [ $diffMtx -eq 1 ] ; then 
    if [ $supportedkernel -eq 0 ]; then
        echo ""
        echo "There's no binaries for your kernel version"
        echo -n "Compile mtx kernel module driver (y/n)? "
        failedcompilation=0
        read str_compileMtx
    else
        str_compileMtx="N"
        echo ""
        echo "Binary available for RedHat $distver, kernel version $VERSION"
        echo "There is no need to compile the kernel module"

    fi


    if [ $str_compileMtx ] ; then
        if [ $str_compileMtx = 'Y' -o $str_compileMtx = 'y' ] ; then
            compileMtx=1
            echo ""
            echo "Messages are being logged in make.log"
            echo "This might take some time"
            echo -n "Compiling mtx.o ..."
            cd kernel/src/
            make clean > /dev/null 2>&1
            make > ../../make.log 2>&1
            if [ $? -ne 0 ]; then
                echo ""
                echo ""
                echo "There has been an error compiling the kernel module. "
                echo "A log file has been created in make.log"
                echo ""
                echo "Press any key to exit"
                read 
                failedcompilation=1
            else
            echo "done."

            fi 
            cd ..
            cd ..
        else
            compileMtx=0
        fi
    else
        compileMtx=0
    fi
    echo ""

    if [ $diffMtx -eq 1 -a $failedcompilation -eq 0 ]; then 

    echo -n "Install the Matrox Kernel Module (y/n)? "
    read str_installMtx
    echo ""

    if [ $str_installMtx ] ; then
        if [ $str_installMtx = 'Y' -o $str_installMtx = 'y' ] ; then
            echo -n "Installing mtx.o..."
            if  test -e $BINARYPATH/mtx.o ; then
                rm $INSTALLDIR/mtx.o.mtxbck.* > /dev/null 2>&1
                install -m 775 -S $BCK_SFFX -b $BINARYPATH/mtx.o $INSTALLDIR/mtx.o
                depmod -a > /dev/null 2>&1 
                echo "done."
                restartX=1
                installMtx=1
                echo "Press any key to continue"
                read -n 1
            else
                echo "No compiled mtx.o available"
                echo "Press any key to continue"
                read -n 1
            fi
        fi
    fi
    echo ""
fi
else
    echo ""
    echo "There's no need to install the Matrox kernel module"
    echo "It's already up to date"
    echo ""
    echo "Press any key to continue"
    read -n 1
fi


clear
# end

echo "==========================================================================="
echo ""
echo "Summary:"
echo ""
    
echo -n "XFree86 driver:             "
if [ $installX -eq 1 ] ; then echo "Updated."
elif [ $diffX -eq 0 ] ; then echo "Already up to date."
else echo "No changes made."
fi
    
echo -n "Parhelia library:           "
if [ $installParhl -eq 1 ] ; then echo "Updated."
elif [ $diffParhl -eq 0 ] ; then echo "Already up to date."
else echo "No changes made."
fi
    
if [ $compileMtx -eq 1 ]; then
    echo -n "Matrox kernel module:       "
    if [ $failedcompilation -eq 1 ] ; then 
        echo "Compilation failed."
        echo "A log has been created in make.log"
    else
        if [ $installMtx -eq 1 ]; then
            echo "Updated."
        elif [ $diffMtx -eq 0 ]; then echo "Already up to date."
        else 
            echo "No changes made."
        fi
    fi
else 
    echo -n "Matrox kernel module:       "
    if [ $installMtx -eq 1 ]; then
        echo "Updated."
    elif [ $diffMtx -eq 0 ]; then echo "Already up to date."
    else 
        echo "No changes made."
    fi
fi



echo ""
if [ $restartX -eq 1 ] ; then
    echo "You must restart the X server for changes to take effect."
    echo""
    echo "Make sure agpgart is loaded. For more information"
    echo "consult the README"
fi
echo ""

exit 0


