/***************************************************************************************\

Module Name:    MtxPte.c

Description:    None.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/


// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "precomp.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

#define PAGE_SIZE               4096L
#define NB_PAGE_INDEX           1024L

// Linear address

#define PAGE_ADDRESS_SHIFT      12L
#define PAGE_ADDRESS_MASK       (0xFFFFFL << PAGE_ADDRESS_SHIFT)

#define PAGE_DIRECTORY_SHIFT    22L
#define PAGE_DIRECTORY_MASK     (0x3FFL << PAGE_DIRECTORY_SHIFT)

#define PAGE_TABLE_SHIFT        12L
#define PAGE_TABLE_MASK         (0x3FFL << PAGE_TABLE_SHIFT)

#define PAGE_OFFSET_SHIFT       0L
#define PAGE_OFFSET_MASK        (0xFFFL << PAGE_OFFSET_SHIFT)

// --------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                  L O C A L   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                         I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

/***************************************************************************************\

Function:       pteMap

Description:    None.

Parameters:     hDirectory
                pvRef

Return Value:   MEMHANDLE 
                Not Specified.

Comments:       None.

\***************************************************************************************/
MEMHANDLE pteMap(
    MEMHANDLE   hDirectory, 
    MEMHANDLE   pvRef)
{
    MEMHANDLE   hTable;
    MEMHANDLE   hTmpDirectory;
    DWORD       dwDirectoryEntry;

    hTable = (MEMHANDLE)0L;
    hTmpDirectory = (MEMHANDLE)0L;

    if (hDirectory == (MEMHANDLE)0L)
    {
        // Map the page directory locally
        hTmpDirectory = pdeMap();
        hDirectory = hTmpDirectory;
    }

    if (hDirectory)
    {
        // Read the page directory entry
        if (pdeReadDword(hDirectory, pvRef, &dwDirectoryEntry))
        {
            // Make sure this entry is present
            if ((dwDirectoryEntry & PDE_P_MASK) == PDE_P_YES)
            {
                // Make sure this entry points to a page table
                if ((dwDirectoryEntry & PDE_PS_MASK) == PDE_PS_4KB)
                {
                    // Map the page table
                    hTable = memMap((dwDirectoryEntry & PDE_ADDR_MASK), PAGE_SIZE);
                }
            }
        }
    }

    if (hTmpDirectory)
    {
        // Unmap the local mapping of the page directory
        pdeUnmap(hTmpDirectory);
        hTmpDirectory = (MEMHANDLE)0L;
    }

    return hTable;
}

/***************************************************************************************\

Function:       pteUnmap

Description:    None.

Parameters:     hTable

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
void pteUnmap(
    MEMHANDLE   hTable)
{
    memUnmap(hTable);
}

/***************************************************************************************\

Function:       pteReadDword

Description:    None.

Parameters:     hTable
                pvRef
                pdwEntry

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD pteReadDword(
    MEMHANDLE   hTable, 
    MEMHANDLE   pvRef, 
    void*       pvEntry)
{
    memReadDword(
        hTable,
        ((pvRef & PAGE_TABLE_MASK) >> PAGE_TABLE_SHIFT) * 4,
        (DWORD*)pvEntry);

    return TRUE;
}

/***************************************************************************************\

Function:       pteReadPage

Description:    None.

Parameters:     hTable
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD pteReadPage(
    MEMHANDLE   hTable, 
    void*       pvBuffer)
{
    memRead(hTable, 0, pvBuffer, PAGE_SIZE);

    return TRUE;
}

/***************************************************************************************\

Function:       pteWriteDword

Description:    None.

Parameters:     hTable
                pvRef
                pvEntry

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD pteWriteDword(
    MEMHANDLE   hTable, 
    MEMHANDLE   pvRef, 
    void*       pvEntry)
{
    memWriteDword(
        hTable,
        ((pvRef & PAGE_TABLE_MASK) >> PAGE_TABLE_SHIFT) * 4,
        *((DWORD*)pvEntry));

    return TRUE;
}
