/***************************************************************************************\

Module Name:    MtxDbg.cpp

Description:    None.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/


// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "precomp.h"
#include <stdio.h>
#include <stdarg.h>

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

typedef void (*FNDEBUGPRINT)(
          void*     pvReserved, 
    const char*     pszFormat, 
          va_list   va);


class DebugHandler
{
public:
    DebugHandler() {}

    virtual ~DebugHandler() {}

    virtual void DebugPrint(
        const char*     ,
              va_list   ) {}
};


class DebugHandlerCallback : public DebugHandler
{
    FNDEBUGPRINT m_pfnPrint;
    void*        m_pvReserved;

public:
    DebugHandlerCallback(
        FNDEBUGPRINT    pfnPrint,
        void*           pvReserved);

    virtual void DebugPrint(
        const char*     pszFormat,
              va_list   va);
};


class DebugHandlerDefault : public DebugHandler
{
public:
    virtual void DebugPrint(
        const char*     pszFormat,
              va_list   va);
};


class DebugHandlerFile : public DebugHandler
{
    FILE* m_fpDebug;

public:
    DebugHandlerFile(
        const char* pszFileName);

    virtual ~DebugHandlerFile();

    virtual void DebugPrint(
        const char*     pszFormat,
              va_list   va);
};


class DebugHandlerMemory : public DebugHandler
{
    char* m_pszDebug;

public:
    DebugHandlerMemory(
        void* pvBuffer);

    virtual void DebugPrint(
        const char*     pszFormat,
              va_list   va);
};

// --------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E S
// --------------------------------------------------------------------------------------

DebugHandlerDefault g_oDebugDefault;

DebugHandler* g_poHandler = &g_oDebugDefault;

// --------------------------------------------------------------------------------------
//                  L O C A L   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                         I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------


/***************************************************************************************\

Function:       DebugHandlerCallback::DebugHandlerCallback

Description:    None.

Parameters:     pfnPrint
                pvReserved

Return Value:   
                Not Specified.

Comments:       None.

\***************************************************************************************/
DebugHandlerCallback::DebugHandlerCallback(
    FNDEBUGPRINT pfnPrint,
    void*        pvReserved) 
:   m_pfnPrint(pfnPrint),
    m_pvReserved(pvReserved)
{
}


/***************************************************************************************\

Function:       DebugHandlerCallback::DebugPrint

Description:    None.

Parameters:     pszFormat
                va

Return Value:   void
                Not Specified.

Comments:       None.

\***************************************************************************************/
void DebugHandlerCallback::DebugPrint(
    const char*     pszFormat,
          va_list   va)
{
    (*m_pfnPrint)(m_pvReserved, pszFormat, va);
}


/***************************************************************************************\

Function:       DebugHandlerFile::DebugHandlerFile

Description:    None.

Parameters:     pszFileName

Return Value:   
                Not Specified.

Comments:       None.

\***************************************************************************************/
DebugHandlerFile::DebugHandlerFile(
    const char* pszFileName)
{
    m_fpDebug = fopen(pszFileName, "w");
}


/***************************************************************************************\

Function:       DebugHandlerFile::~DebugHandlerFile

Description:    None.

Parameters:     

Return Value:   
                Not Specified.

Comments:       None.

\***************************************************************************************/
DebugHandlerFile::~DebugHandlerFile()
{
    if (m_fpDebug)
    {
        fclose(m_fpDebug);
    }
}


/***************************************************************************************\

Function:       DebugHandlerFile::DebugPrint

Description:    None.

Parameters:     pszFormat
                va

Return Value:   
                Not Specified.

Comments:       None.

\***************************************************************************************/
void DebugHandlerFile::DebugPrint(
    const char*     pszFormat,
          va_list   va)
{
    if (m_fpDebug)
    {
        vfprintf(m_fpDebug, pszFormat, va);
    }
}


/***************************************************************************************\

Function:       DebugHandlerMemory::DebugHandlerMemory

Description:    None.

Parameters:     pvBuffer

Return Value:   
                Not Specified.

Comments:       None.

\***************************************************************************************/
DebugHandlerMemory::DebugHandlerMemory(
    void* pvBuffer)
:   m_pszDebug((char*)pvBuffer)
{
}


/***************************************************************************************\

Function:       DebugHandlerMemory::DebugPrint

Description:    None.

Parameters:     pszFormat
                va

Return Value:   
                Not Specified.

Comments:       None.

\***************************************************************************************/
void DebugHandlerMemory::DebugPrint(
    const char*     pszFormat,
          va_list   va)
{
    if (m_pszDebug)
    {
        int lCount = vsprintf(m_pszDebug, pszFormat, va);

        if (lCount > 0)
        {
            m_pszDebug += lCount;
        }
    }
}


/***************************************************************************************\

Function:       DebugPrintDefault

Description:    None.

Parameters:     pszFormat
                va

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
void DebugHandlerDefault::DebugPrint(
    const char*     pszFormat, 
          va_list   va)
{
    vprintf(pszFormat, va);
}


/***************************************************************************************\

Function:       DebugOpenFile

Description:    None.

Parameters:     pszFileName

Return Value:   DEBUGHANDLE 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DEBUGHANDLE DebugOpenFile(
    const char* pszFileName)
{
    DebugHandler* poHandler = g_poHandler;

    g_poHandler = new DebugHandlerFile(pszFileName);

    return poHandler;
}


/***************************************************************************************\

Function:       DebugOpenMemory

Description:    None.

Parameters:     pszBuffer

Return Value:   DEBUGHANDLE 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DEBUGHANDLE DebugOpenMemory(
    void* pszBuffer)
{
    DebugHandler* poHandler = g_poHandler;

    g_poHandler = new DebugHandlerMemory(pszBuffer);

    return poHandler;
}


/***************************************************************************************\

Function:       DebugOpenDefault

Description:    None.

Parameters:     

Return Value:   DEBUGHANDLE 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DEBUGHANDLE DebugOpenDefault()
{
    DebugHandler* poHandler = g_poHandler;

    g_poHandler = &g_oDebugDefault;

    return poHandler;
}


/***************************************************************************************\

Function:       DebugOpenCallback

Description:    None.

Parameters:     pfnPrint
                pvReserved

Return Value:   DEBUGHANDLE 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DEBUGHANDLE DebugOpenCallback(
    void* pfnPrint,
    void* pvReserved)
{
    DebugHandler* poHandler = g_poHandler;

    g_poHandler = new DebugHandlerCallback((FNDEBUGPRINT)pfnPrint, pvReserved);

    return poHandler;
}


/***************************************************************************************\

Function:       DebugClose

Description:    None.

Parameters:     poHandler

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
void DebugClose(
    DEBUGHANDLE poHandler)
{
    if (g_poHandler)
    {
        if (g_poHandler != &g_oDebugDefault)
        {
            delete g_poHandler;
        }
    }

    g_poHandler = (DebugHandler*)poHandler;
}


/***************************************************************************************\

Function:       DebugPrint

Description:    None.

Parameters:     pszFormat
                ...

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
void DebugPrint(const char* pszFormat, ...)
{
    va_list va;
    va_start(va, pszFormat);

    if (g_poHandler)
    {
        g_poHandler->DebugPrint(pszFormat, va);
    }

    va_end(va);
}
