/***************************************************************************************\

Module Name:    MtxDbg.cpp

Description:    None.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/


// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include <linux/kernel.h>
#include "mtx_drv.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

#define MAX_DEBUG_STRING_LENGTH 125

static char g_acDebugString[MAX_DEBUG_STRING_LENGTH] = {""};

// --------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                  L O C A L   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                         I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

/***************************************************************************************\

Function:       dbgOutputVA

Description:    None.

Parameters:     pszFormat

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
void dbgOutput(const char* pszFormat, va_list va)
{
    // Print message to klog
    printk(pszFormat);
}

/***************************************************************************************\

Function:       dbgOutputVA

Description:    None.

Parameters:     pszFormat
                va

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
void dbgOutputVA(const char* pszFormat, va_list va)
{
    // Resolve string to our temporary buffer 
    vsnprintf(g_acDebugString, MAX_DEBUG_STRING_LENGTH, pszFormat, va);

    // Print result to klog
    printk(g_acDebugString);
}
