/***************************************************************************************\

Module Name:    MtxCs.c

Description:    Access to configuration space registers

References:     

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/


// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "precomp.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

#define CONFIG_INDEX    0xCF8
#define CONFIG_DATA     0xCFC

// --------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                  L O C A L   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                         I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------


/***************************************************************************************\

Function:       csReadWrite

Description:    None.

Parameters:     None.

Return Value:   DWORD
                None.

Comments:       None.

\***************************************************************************************/
DWORD csReadWrite(PCIHANDLE hDevice, DWORD iOffset, void* pvBuffer, DWORD iSize, DWORD iAccess)
{
    DWORD dwSave;
    DWORD iWalk = 0;

    ioReadDword(CONFIG_INDEX, &dwSave);

    while (iWalk < iSize)
    {
        ioWriteDword(CONFIG_INDEX, (0x80000000L | (hDevice << 8) | (DWORD)((iOffset + iWalk) & (~3))));
        
        if ((((iOffset + iWalk) & 3) == 0) && ((iSize - iWalk) >= 4))
        {
            ioReadWrite(CONFIG_DATA + ((iOffset + iWalk) & 3), ((BYTE*)pvBuffer + iWalk), 4, iAccess);

            iWalk += 4;
        }
        else if ((((iOffset + iWalk) & 1) == 0) && ((iSize - iWalk) >= 2))
        {
            ioReadWrite(CONFIG_DATA + ((iOffset + iWalk) & 3), ((BYTE*)pvBuffer + iWalk), 2, iAccess);

            iWalk += 2;
        }
        else
        {
            ioReadWrite(CONFIG_DATA + ((iOffset + iWalk) & 3), ((BYTE*)pvBuffer + iWalk), 1, iAccess);

            iWalk ++;
        }
    }

    ioWriteDword(CONFIG_INDEX, dwSave);

    return (TRUE);
}


/***************************************************************************************\

Function:       csRead

Description:    None.

Parameters:     None.

Return Value:   DWORD
                None.

Comments:       None.

\***************************************************************************************/
DWORD csRead(PCIHANDLE hDevice, DWORD iOffset, void* pvBuffer, DWORD iSize)
{
    return csReadWrite(hDevice, iOffset, pvBuffer, iSize, 0);
}


/***************************************************************************************\

Function:       csReadDword

Description:    None.

Parameters:     None.

Return Value:   DWORD
                None.

Comments:       None.

\***************************************************************************************/
DWORD csReadDword(PCIHANDLE hPci, DWORD iOffset, DWORD* pvBuffer)
{
    return csRead(hPci, iOffset, pvBuffer, sizeof(DWORD));
}


/***************************************************************************************\

Function:       csReadWord

Description:    None.

Parameters:     None.

Return Value:   DWORD
                None.

Comments:       None.

\***************************************************************************************/
DWORD csReadWord(PCIHANDLE hPci, DWORD iOffset, WORD* pvBuffer)
{
    return csRead(hPci, iOffset, pvBuffer, sizeof(WORD));
}


/***************************************************************************************\

Function:       csReadByte

Description:    None.

Parameters:     None.

Return Value:   DWORD
                None.

Comments:       None.

\***************************************************************************************/
DWORD csReadByte(PCIHANDLE hPci, DWORD iOffset, BYTE* pvBuffer)
{
    return csRead(hPci, iOffset, pvBuffer, sizeof(BYTE));
}


/***************************************************************************************\

Function:       csWrite

Description:    None.

Parameters:     None.

Return Value:   DWORD
                None.

Comments:       None.

\***************************************************************************************/
DWORD csWrite(PCIHANDLE hDevice, DWORD iOffset, void* pvBuffer, DWORD iSize)
{
    return csReadWrite(hDevice, iOffset, pvBuffer, iSize, 1);
}


/***************************************************************************************\

Function:       csWriteDword

Description:    None.

Parameters:     None.

Return Value:   DWORD
                None.

Comments:       None.

\***************************************************************************************/
DWORD csWriteDword(PCIHANDLE hPci, DWORD iOffset, DWORD pvBuffer)
{
    return csWrite(hPci, iOffset, &pvBuffer, sizeof(pvBuffer));
}


/***************************************************************************************\

Function:       csWriteWord

Description:    None.

Parameters:     None.

Return Value:   DWORD 
                None.

Comments:       None.

\***************************************************************************************/
DWORD csWriteWord(PCIHANDLE hPci, DWORD iOffset, WORD pvBuffer)
{
    return csWrite(hPci, iOffset, &pvBuffer, sizeof(pvBuffer));
}


/***************************************************************************************\

Function:       csWriteByte

Description:    None.

Parameters:     None.

Return Value:   DWORD 
                None.

Comments:       None.

\***************************************************************************************/
DWORD csWriteByte(PCIHANDLE hPci, DWORD iOffset, BYTE pvBuffer)
{
    return csWrite(hPci, iOffset, &pvBuffer, sizeof(pvBuffer));
}
