/***************************************************************************************\

Module Name:    MtxCpu.c

Description:    Interface for CPU resources.

References:     MtxCpu.htm

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "precomp.h"
#include "asm/io.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                  L O C A L   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                         I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------


/***************************************************************************************\

Function:       cpuReadWrite

Description:    None.

Parameters:     None.

Return Value:   DWORD
                TRUE on success, FALSE otherwise.

Comments:       None.

\***************************************************************************************/
DWORD cpuReadWrite(
    DWORD   lBank,
    DWORD   lIndex,
    void*   pvBuffer,
    DWORD   lAccess)
{
    if (lAccess == 0)
    {
        return cpuRead(lBank, lIndex, pvBuffer);
    }
    else
    {
        return cpuWrite(lBank, lIndex, pvBuffer);
    }
}


/***************************************************************************************\

Function:       cpuRead

Description:    None.

Parameters:     None.

Return Value:   DWORD
                TRUE on success, FALSE otherwise.

Comments:       None.

\***************************************************************************************/
DWORD cpuRead(
    DWORD   lBank,
    DWORD   lIndex,
    void*   pvBuffer)
{
    switch (lBank)
    {
        case CPU_BANK_SREGS:
            switch (lIndex)
            {
                case CPU_INDEX_EFLAGS:
                case CPU_INDEX_GDTR:
                case CPU_INDEX_IDTR:
                case CPU_INDEX_LDTR:
                case CPU_INDEX_TR:
                case CPU_INDEX_MXCSR:
                case CPU_INDEX_TSC:
                case CPU_INDEX_MSW:
                default:
                    return FALSE;
            }
            break;

        case CPU_BANK_CREGS:
            switch (lIndex)
            {
                case CPU_INDEX_CR0:
                case CPU_INDEX_CR2:
                case CPU_INDEX_CR3:
                case CPU_INDEX_CR4:
                default:
                    return FALSE;
            }
            break;

        case CPU_BANK_DREGS:
            switch (lIndex)
            {
                case CPU_INDEX_DR0:
                case CPU_INDEX_DR1:
                case CPU_INDEX_DR2:
                case CPU_INDEX_DR3:
                case CPU_INDEX_DR6:
                case CPU_INDEX_DR7:
                default:
                    return FALSE;
            }
            break;

        case CPU_BANK_IO_BYTE:
            *(BYTE *)pvBuffer = inb(lIndex);
            break;

        case CPU_BANK_IO_WORD:
            *(WORD *)pvBuffer = inw(lIndex);
            break;

        case CPU_BANK_IO_DWORD:
            *(DWORD *)pvBuffer = inl(lIndex);
            break;


        case CPU_BANK_CPUID:
        case CPU_BANK_MSR:
        case CPU_BANK_PMC:
        default:
            return FALSE;
    }

    return TRUE;
}


/***************************************************************************************\

Function:       cpuWrite

Description:    None.

Parameters:     None.

Return Value:   DWORD
                TRUE on success, FALSE otherwise.

Comments:       None.

\***************************************************************************************/
DWORD cpuWrite(
    DWORD   lBank,
    DWORD   lIndex,
    void*   pvBuffer)
{
    switch (lBank)
    {
        case CPU_BANK_SREGS:
            switch (lIndex)
            {
                case CPU_INDEX_EFLAGS:
                case CPU_INDEX_GDTR:
                case CPU_INDEX_IDTR:
                case CPU_INDEX_LDTR:
                case CPU_INDEX_TR:
                case CPU_INDEX_MXCSR:
                case CPU_INDEX_MSW:
                default:
                    return FALSE;
            }
            break;

        case CPU_BANK_CREGS:
            switch (lIndex)
            {
                case CPU_INDEX_CR0:
                case CPU_INDEX_CR2:
                case CPU_INDEX_CR3:
                case CPU_INDEX_CR4:
                default:
                    return FALSE;
            }
            break;

        case CPU_BANK_DREGS:
            switch (lIndex)
            {
                case CPU_INDEX_DR0:
                case CPU_INDEX_DR1:
                case CPU_INDEX_DR2:
                case CPU_INDEX_DR3:
                case CPU_INDEX_DR6:
                case CPU_INDEX_DR7:
                default:
                    return FALSE;
            }
            break;

        case CPU_BANK_IO_BYTE:
            outb(*(BYTE *)pvBuffer, lIndex);
            break;

        case CPU_BANK_IO_WORD:
            outw(*(WORD *)pvBuffer, lIndex);
            break;

        case CPU_BANK_IO_DWORD:
            outl(*(DWORD *)pvBuffer, lIndex);
            break;

        case CPU_BANK_MSR:
        default:
            return FALSE;
    }

    return TRUE;
}
