#ifndef _PCI_H
#define _PCI_H

/*++

Filename:       Pci.h

Description:    Definitions for pci registers and functions.

Documentation:  Check out the following PDF files:

                    \\urgent\projects\mgihard\public\spec...\PCI_Spec\pci22rd2.pdf
                    \\urgent\projects\mgihard\public\spec...\AGP_Spec\Agp2.0.pdf
                    \\urgent\projects\mgihard\public\spec...\PCI_Spec\Bridge\ppb11.pdf

Comments:     - The functions are implemented in Pci.c.  If you include this file, then
                you will need MtxVxd.h and MtxVxd.lib

--*/

#include "MtxPci.h"

// Function prototypes
EXTERN_C DWORD pciReadDword(PCIHANDLE hPCI, DWORD ulOffset, DWORD *pdData);
EXTERN_C DWORD pciReadWord(PCIHANDLE hPCI, DWORD ulOffset, WORD *pwData);
EXTERN_C DWORD pciReadByte(PCIHANDLE hPCI, DWORD ulOffset, BYTE *pbData);
EXTERN_C DWORD pciWriteDword(PCIHANDLE hPCI, DWORD ulOffset, DWORD dwData);
EXTERN_C DWORD pciWriteWord(PCIHANDLE hPCI, DWORD ulOffset, WORD wData);
EXTERN_C DWORD pciWriteByte(PCIHANDLE hPCI, DWORD ulOffset, BYTE bData);

#endif // _PCI_H
