/***************************************************************************************\

Module Name:    MtxMem.inl

Description:    Access to physical memory.

References:     MtxMem.htm

    Copyright (c) 2001, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXMEM_INL
#define INC_MTXMEM_INL

// --------------------------------------------------------------------------------------
//                                  I N L I N E S
// --------------------------------------------------------------------------------------

/***************************************************************************************\

Function:       memReadWrite

Description:    None.

Parameters:     hMemory
                dwOffset
                pvBuffer
                dwSize
                dwAccess

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
void memReadWrite(
    MEMHANDLE   hMemory,
    DWORD       dwOffset,
    void*       pvBuffer,
    DWORD       dwSize,
    DWORD       dwAccess)
{
    if (dwAccess == 0)
    {
        memRead(hMemory, dwOffset, pvBuffer, dwSize);
    }
    else
    {
        memWrite(hMemory, dwOffset, pvBuffer, dwSize);
    }
}

/***************************************************************************************\

Function:       memReadByte

Description:    None.

Parameters:     hMemory
                dwOffset
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
void memReadByte(
    MEMHANDLE   hMemory,
    DWORD       dwOffset,
    BYTE*       pvBuffer)
{
    *pvBuffer = cpuReadMemoryByte(hMemory + dwOffset);
}

/***************************************************************************************\

Function:       memReadWord

Description:    None.

Parameters:     hMemory
                dwOffset
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
void memReadWord(
    MEMHANDLE   hMemory,
    DWORD       dwOffset,
    WORD*       pvBuffer)
{
    *pvBuffer = cpuReadMemoryWord(hMemory + dwOffset);
}

/***************************************************************************************\

Function:       memReadDword

Description:    None.

Parameters:     hMemory
                dwOffset
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
void memReadDword(
    MEMHANDLE   hMemory,
    DWORD       dwOffset,
    DWORD*      pvBuffer)
{
    *pvBuffer = cpuReadMemoryDword(hMemory + dwOffset);
}

/***************************************************************************************\

Function:       memWriteByte

Description:    None.

Parameters:     hMemory
                dwOffset
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
void memWriteByte(
    MEMHANDLE   hMemory,
    DWORD       dwOffset,
    BYTE        pvBuffer)
{
    cpuWriteMemoryByte(hMemory + dwOffset, pvBuffer);
}

/***************************************************************************************\

Function:       memWriteWord

Description:    None.

Parameters:     hMemory
                dwOffset
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
void memWriteWord(
    MEMHANDLE   hMemory,
    DWORD       dwOffset,
    WORD        pvBuffer)
{
    cpuWriteMemoryWord(hMemory + dwOffset, pvBuffer);
}

/***************************************************************************************\

Function:       memWriteDword

Description:    None.

Parameters:     hMemory
                dwOffset
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
void memWriteDword(
    MEMHANDLE   hMemory,
    DWORD       dwOffset,
    DWORD       pvBuffer)
{
    cpuWriteMemoryDword(hMemory + dwOffset, pvBuffer);
}

#endif  // #ifndef INC_MTXMEM_INL
