/***************************************************************************************\

Module Name:    MtxGdtr.h

Description:    None.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXGDTR_H
#define INC_MTXGDTR_H

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "MtxMem.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

typedef struct _GDTR {

    DWORD dwValueLO;
    DWORD dwValueHI;

} GDTR;

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

//
//  Interface for GDTR/IDTR register
//
EXTERN_C DWORD gdtrRead(
    GDTR*       pvReg
);

EXTERN_C DWORD gdtrWrite(
    GDTR*       pvReg
);

EXTERN_C DWORD gdtrGetLimit(
    GDTR*       pvReg
);

EXTERN_C MEMHANDLE gdtrGetBase(
    GDTR*       pvReg
);

EXTERN_C void gdtrSetLimit(
    GDTR*       pvReg, 
    DWORD       lLimit
);

EXTERN_C void gdtrSetBase(
    GDTR*       pvReg, 
    MEMHANDLE   lBase
);

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_MTXGDTR_H
