/***************************************************************************************\

Module Name:    MtxCs.h

Description:    Definitions for CS access.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXCS_H
#define INC_MTXCS_H

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "MtxType.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

typedef DWORD PCIHANDLE;

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

EXTERN_C DWORD csReadWrite(
    PCIHANDLE  hPci,
    DWORD      iOffset,
    void*      pvBuffer,
    DWORD      iSize,
    DWORD      iAccess
);

EXTERN_C DWORD csRead(
    PCIHANDLE  hPci, 
    DWORD      iOffset, 
    void*      pvBuffer, 
    DWORD      iSize
);

EXTERN_C DWORD csReadDword(
    PCIHANDLE  hPci, 
    DWORD      iOffset, 
    DWORD*     pvBuffer
);

EXTERN_C DWORD csReadWord(
    PCIHANDLE  hPci, 
    DWORD      iOffset, 
    WORD*      pvBuffer
);

EXTERN_C DWORD csReadByte(
    PCIHANDLE  hPci, 
    DWORD      iOffset, 
    BYTE*      pvBuffer
);

EXTERN_C DWORD csWrite(
    PCIHANDLE  hPci, 
    DWORD      iOffset, 
    void*      pvBuffer, 
    DWORD      iSize
);

EXTERN_C DWORD csWriteDword(
    PCIHANDLE  hPci, 
    DWORD      iOffset, 
    DWORD      pvBuffer
);

EXTERN_C DWORD csWriteWord(
    PCIHANDLE  hPci, 
    DWORD      iOffset, 
    WORD       pvBuffer
);

EXTERN_C DWORD csWriteByte(
    PCIHANDLE  hPci, 
    DWORD      iOffset, 
    BYTE       pvBuffer
);

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_MTXCS_H
