/***************************************************************************************\

Module Name:    MtxCpuOs.inl

Description:    Inline functions for access to CPU resources.

References:     MtxCpu.htm

    Copyright (c) 2001, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXCPUOS_INL
#define INC_MTXCPUOS_INL

// --------------------------------------------------------------------------------------
//                                  I N L I N E S
// --------------------------------------------------------------------------------------

/***************************************************************************************\

Function:       cpuReadMemoryByte

Description:    None.

Parameters:     hMemory

Return Value:   BYTE 
                Not Specified.

Comments:       None.

\***************************************************************************************/
BYTE cpuReadMemoryByte(
    MEMHANDLE hMemory)
{
    return ((volatile BYTE *)hMemory)[0];
}

/***************************************************************************************\

Function:       cpuReadMemoryWord

Description:    None.

Parameters:     hMemory

Return Value:   WORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
WORD cpuReadMemoryWord(
    MEMHANDLE   hMemory)
{
    return ((volatile WORD*)hMemory)[0];
}

/***************************************************************************************\

Function:       cpuReadMemoryDword

Description:    None.

Parameters:     hMemory

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD cpuReadMemoryDword(
    MEMHANDLE   hMemory)
{
    return ((volatile DWORD*)hMemory)[0];
}

/***************************************************************************************\

Function:       cpuWriteMemoryByte

Description:    None.

Parameters:     hMemory
                byValue

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
void cpuWriteMemoryByte(
    MEMHANDLE   hMemory,
    BYTE        byValue)
{
    ((volatile BYTE*)hMemory)[0] = byValue;
}

/***************************************************************************************\

Function:       cpuWriteMemoryWord

Description:    None.

Parameters:     hMemory
                wValue

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
void cpuWriteMemoryWord(
    MEMHANDLE   hMemory,
    WORD        wValue)
{
    ((volatile WORD*)hMemory)[0] = wValue;
}

/***************************************************************************************\

Function:       cpuWriteMemoryDword

Description:    None.

Parameters:     hMemory
                dwValue

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
void cpuWriteMemoryDword(
    MEMHANDLE   hMemory,
    DWORD       dwValue)
{
    ((volatile DWORD*)hMemory)[0] = dwValue;
}

#endif  // #ifndef INC_MTXCPUOS_INL
