/***************************************************************************************\

Module Name:    MtxCpu.h

Description:    Interface for CPU resources.

References:     MtxCpu.htm

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXCPU_H
#define INC_MTXCPU_H

// --------------------------------------------------------------------------------------
//                      H E A D E R   F I L E S   R E Q U I R E D
// --------------------------------------------------------------------------------------

#include "MtxType.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

// Register banks for cpuReadWrite
#define CPU_BANK_SREGS              0
#define CPU_BANK_CREGS              1   // 4 bytes
#define CPU_BANK_DREGS              2   // 4 bytes
#define CPU_BANK_CPUID              3   // 16 bytes
#define CPU_BANK_MSR                4   // 8 bytes
#define CPU_BANK_PMC                5   // 8 bytes
#define CPU_BANK_IO_BYTE            6   // 1 byte
#define CPU_BANK_IO_WORD            7   // 2 bytes
#define CPU_BANK_IO_DWORD           8   // 4 bytes
#define CPU_BANK_DTE                9   // 8 bytes
#define CPU_BANK_PTE                10  // 4 bytes

// Indexes for CPU_BANK_SREGS
#define CPU_INDEX_EFLAGS            0   // 4 bytes
#define CPU_INDEX_GDTR              1   // 6 bytes
#define CPU_INDEX_IDTR              2   // 6 bytes
#define CPU_INDEX_LDTR              3   // 2 bytes
#define CPU_INDEX_TR                4   // 2 bytes
#define CPU_INDEX_MXCSR             5   // 4 bytes
#define CPU_INDEX_TSC               6   // 8 bytes
#define CPU_INDEX_MSW               7   // 2 bytes
#define CPU_INDEX_CS                8   // 4 bytes
#define CPU_INDEX_DS                9   // 4 bytes
#define CPU_INDEX_ES                10  // 4 bytes
#define CPU_INDEX_FS                11  // 4 bytes
#define CPU_INDEX_GS                12  // 4 bytes
#define CPU_INDEX_SS                13  // 4 bytes

// Indexes for CPU_BANK_CREGS
#define CPU_INDEX_CR0               0
#define CPU_INDEX_CR2               2
#define CPU_INDEX_CR3               3
#define CPU_INDEX_CR4               4

// Indexes for CPU_BANK_DREGS
#define CPU_INDEX_DR0               0
#define CPU_INDEX_DR1               1
#define CPU_INDEX_DR2               2
#define CPU_INDEX_DR3               3
#define CPU_INDEX_DR6               6
#define CPU_INDEX_DR7               7

// Definitions for lCommand parameter
#define CPU_COMMAND_CPUID_DETECT    0
#define CPU_COMMAND_WBINVD          1
#define CPU_COMMAND_FLUSHTLB        2
#define CPU_COMMAND_INTERRUPT       3

// --------------------------------------------------------------------------------------
//                  G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

EXTERN_C DWORD cpuReadWrite(
    DWORD   lBank,
    DWORD   lIndex,
    void*   pvBuffer,
    DWORD   lAccess);

EXTERN_C DWORD cpuRead(
    DWORD   lBank,
    DWORD   lIndex,
    void*   pvBuffer);

EXTERN_C DWORD cpuWrite(
    DWORD   lBank,
    DWORD   lIndex,
    void*   pvBuffer);

EXTERN_C DWORD cpuExec(
    DWORD   lCommand,
    void*   pvInput,
    void*   pvOutput);

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif // #ifndef INC_MTXCS_H
