/***************************************************************************************\

Module Name:    Mono.h

Description:    Definitions for monochrome display adapters.

References:     La Bible du PC

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MONO_H
#define INC_MONO_H

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------
#include <Windows.h>

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------
//
// Registre d'attribut
//
typedef union _MONOATTR
{
    BYTE all;

    struct
    {
        BYTE fcol       :3;
        BYTE bold       :1;
        BYTE bcol       :3;
        BYTE blink      :1;
    };

} MONOATTR;

#define MONOATTR_FCOL_MASK          0x07
#define MONOATTR_FCOL_BLACK         0x00
#define MONOATTR_FCOL_UNDERLINE     0x01
#define MONOATTR_FCOL_WHITE         0x07
#define MONOATTR_BOLD               0x08
#define MONOATTR_BCOL_MASK          0x70
#define MONOATTR_BCOL_BLACK         0x00
#define MONOATTR_BCOL_WHITE         0x70
#define MONOATTR_BLINK              0x80


//
// 
//
#define IO_MDA_CONTROL 0x3B8

typedef union _ST_MGA_CONTROL
{
    BYTE all;

    struct
    {
        BYTE enable     :1;
        BYTE rsvd1_2    :2;
        BYTE image      :1;
        BYTE rsvd4      :1;
        BYTE blink      :1;
        BYTE rsvd6_7    :2;
    };

} ST_MDA_CONTROL;

#define MDA_CONTROL_ENABLE      0x01
#define MDA_CONTROL_IMAGE       0x08
#define MDA_CONTROL_BLINK       0x20
#define MDA_CONTROL_DEFAULT     0x29


#define IO_MDA_STATUS 0x3B8

typedef union _ST_MDA_STATUS
{
    BYTE all;

    struct
    {
        BYTE hsync      :1;
        BYTE rsvd1_2    :2;
        BYTE pixel      :1;
        BYTE rsvd4_7    :4;
    };

} ST_MDA_STATUS;

#define MDA_STATUS_HSYNC        0x01
#define MDA_STATUS_PIXEL        0x08


//
// 6845
//
#define IO_MDA_CRT_INDEX   0x3B4
#define IO_MDA_CRT_DATA    0x3B5

#define MDA_CRT_0  0x00 // Total de caracteres horizontalement
#define MDA_CRT_1  0x01 // Caracteres affiches horizontalement
#define MDA_CRT_2  0x02 // Signal de synchronisation horizontal apres X caracteres
#define MDA_CRT_3  0x03 // Duree du signal horizontal de synchronisation en caracteres
#define MDA_CRT_4  0x04 // Total de caracteres verticalement
#define MDA_CRT_5  0x05 // Nombre ajuste de caracteres verticalement
#define MDA_CRT_6  0x06 // Caracteres affiches verticalement
#define MDA_CRT_7  0x07 // Signal de synchronisation vertical apres X caracteres
#define MDA_CRT_8  0x08 // Mode d'entrelacement
#define MDA_CRT_9  0x09 // Nombre de lignes de grille par ligne de l'ecran
#define MDA_CRT_A  0x0A // Ligne de depart du curseur clignotant de l'ecran
#define MDA_CRT_B  0x0B // Ligne de fin du curseur clignotant de l'ecran
#define MGA_CRT_C  0x0C // Adresse de depart de la page ecran affichee (poids fort)
#define MGA_CRT_D  0x0D // Adresse de depart de la page ecran affichee (poids faible)
#define MGA_CRT_E  0x0E // Adresse de caractere du curseur clignotant de l'ecran (poids fort)
#define MGA_CRT_F  0x0F // Adresse de caractere du curseur clignotant de l'ecran (poids faible)
#define MGA_CRT_10 0x10 // Position du crayon optique (poids fort)
#define MGA_CRT_11 0x11 // Position du crayon optique (poids faible)


//
// Registre de configuration
//
#define IO_HGC_CONFIG 0x3BF

typedef union _ST_HGC_CONFIG
{
    BYTE all;

    struct
    {
        BYTE hiresavail     :1;
        BYTE page1avail     :1;
        BYTE rsvd2_7        :6;
    };

} ST_HGC_CONFIG;

#define HGC_CONFIG_HIRESAVAIL       0x01
#define HGC_CONFIG_PAGE1AVAIL       0x02


//
// Registre de controle
//
#define IO_HGC_CONTROL 0x3B8

typedef union _ST_HGC_CONTROL
{
    BYTE all;

    struct
    {
        BYTE rsvd0          :1;
        BYTE mode           :1;
        BYTE rsvd2          :1;
        BYTE videosignal    :1;
        BYTE rsvd4          :1;
        BYTE blink          :1;
        BYTE rsvd6          :1;
        BYTE page           :1;
    };

} ST_HGC_CONTROL;

#define HDC_CONTROL_MODE_MASK   0x02
#define HGC_CONTROL_MODE_TEXT   0x00
#define HGC_CONTROL_MODE_HIRES  0x02
#define HGC_CONTROL_VIDEOSIGNAL 0x08
#define HGC_CONTROL_BLINK       0x20
#define HGC_CONTROL_PAGE_MASK   0x80
#define HGC_CONTROL_PAGE_0      0x00
#define HGC_CONTROL_PAGE_1      0x80


//
// Registre d'etat
//
#define IO_HGC_STATUS 0x3B8

typedef union _ST_HGC_STATUS
{
    BYTE all;

    struct
    {
        BYTE hsync          :1;
        BYTE rsvd1_2        :2;
        BYTE pixel          :1;
        BYTE rsvd4_6        :3;
        BYTE vsync          :1;
    };

} ST_HGC_STATUS;

#define HGC_STATUS_HSYNC        0x01
#define HGC_STATUS_PIXEL        0x08
#define HGC_STATUS_VSYNC        0x80

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_MONO_H
