// xmemory internal header (from <memory>)

#ifndef _MTLXMEMORY_
#define _MTLXMEMORY_
//#include <cstdlib>
//#include <new>
#include "MtlTypeTraits.h"

// #include <utility>
#ifndef _PTRDIFF_T_DEFINED
typedef int ptrdiff_t;
#define _PTRDIFF_T_DEFINED
#endif


#ifndef _SIZE_T_DEFINED
typedef unsigned int size_t;
#define _SIZE_T_DEFINED
#endif


#ifndef _WCHAR_T_DEFINED
typedef unsigned short wchar_t;
#define _WCHAR_T_DEFINED
#endif

#define _CRTIMP

#ifndef _FARQ	/* specify standard memory model */
 #define _FARQ
 #define _PDFT	ptrdiff_t
 #define _SIZT	size_t
#endif
 #define _POINTER_X(T, A)	T _FARQ *
 #define _REFERENCE_X(T, A)	T _FARQ &

#ifndef MTLBEGIN
#define MTLBEGIN        namespace Mtl{
#define MTLEND          }
#endif

MTLBEGIN
// TEMPLATE FUNCTION _Allocate
template<class _Ty> inline
_Ty _FARQ *_Allocate(_PDFT _N, _Ty _FARQ *)
{if (_N < 0)
_N = 0;
return ((_Ty _FARQ *)operator new(
        (_SIZT)_N * sizeof (_Ty))); }
// TEMPLATE FUNCTION _Construct
template<class _T1, class _T2> inline
void _Construct(_T1 _FARQ *_P, const _T2& _V)
{new ((void _FARQ *)_P) _T1(_V); }
// TEMPLATE FUNCTION _Destroy
/*
template<class _Ty> inline
void _Destroy(_Ty _FARQ *_P)
{_DESTRUCTOR(_Ty, _P); }
*/
// TEMPLATE FUNCTION _Destroy from STLport file: _construct.h
# ifdef MTL_TRIVIAL_DESTRUCTOR_BUG
template <class _Tp>
inline void __destroy_aux(_Tp* __pointer, __false_type) { __pointer->_Tp::~_Tp(); }
template <class _Tp>
inline void __destroy_aux(_Tp* __pointer, __true_type) {}
#else
inline void _Destroy(char _FARQ *_P)
{}
inline void _Destroy(wchar_t _FARQ *_P)
{}
# endif

template <class _Tp>
inline void _Destroy(_Tp* __pointer) {
    __pointer;
# ifdef MTL_TRIVIAL_DESTRUCTOR_BUG
    typedef typename __type_traits<_Tp>::has_trivial_destructor
        _Trivial_destructor;
    __destroy_aux(__pointer, _Trivial_destructor());
# else
    //#  if ( defined (__BORLANDC__) && ( __BORLANDC__ < 0x500 ) )
    //    __pointer->_Tp::~_Tp();
    //#  else
    __pointer->~_Tp();
    //#  endif
# endif
}

// TEMPLATE CLASS allocator
template<class _Ty>
	class allocator {
public:
	typedef _SIZT size_type;
	typedef _PDFT difference_type;
	typedef _Ty _FARQ *pointer;
	typedef const _Ty _FARQ *const_pointer;
	typedef _Ty _FARQ& reference;
	typedef const _Ty _FARQ& const_reference;
	typedef _Ty value_type;
	pointer address(reference _X) const
		{return (&_X); }
	const_pointer address(const_reference _X) const
		{return (&_X); }
	pointer allocate(size_type _N, const void *)
		{return (_Allocate((difference_type)_N, (pointer)0)); }
	char _FARQ *_Charalloc(size_type _N)
		{return (_Allocate((difference_type)_N,
			(char _FARQ *)0)); }
	void deallocate(void _FARQ *_P, size_type)
		{operator delete(_P); }
	void construct(pointer _P, const _Ty& _V)
		{_Construct(_P, _V); }
	void destroy(pointer _P)
		{_Destroy(_P); }
	_SIZT max_size() const
		{_SIZT _N = (_SIZT)(-1) / sizeof (_Ty);
		return (0 < _N ? _N : 1); }
	};
template<class _Ty, class _U> inline
	BOOL operator==(const allocator<_Ty>&, const allocator<_U>&)
	{return (TRUE); }
template<class _Ty, class _U> inline
	BOOL operator!=(const allocator<_Ty>&, const allocator<_U>&)
	{return (FALSE); }
		// CLASS allocator<void>
template<> class _CRTIMP allocator<void> {
public:
	typedef void _Ty;
	typedef _Ty _FARQ *pointer;
	typedef const _Ty _FARQ *const_pointer;
	typedef _Ty value_type;
	};
MTLEND

#endif /* _MTLXMEMORY_ */

/*
 * Copyright (c) 1995 by P.J. Plauger.  ALL RIGHTS RESERVED. 
 * Consult your license regarding permissions and restrictions.
 */

/*
 * This file is derived from software bearing the following
 * restrictions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Permission to use, copy, modify, distribute and sell this
 * software and its documentation for any purpose is hereby
 * granted without fee, provided that the above copyright notice
 * appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation.
 * Hewlett-Packard Company makes no representations about the
 * suitability of this software for any purpose. It is provided
 * "as is" without express or implied warranty.
 */
