 /***************************************************************************\
|*                                                                           *|
|*       Copyright 2002 Matrox Graphics Inc. All rights reserved.            *|
|*                                                                           *|
|*     NOTICE TO THE USER: This source code is the copyrighted work of       *| 
|*     Matrox. Users of this source code are hereby granted a nonexclusive,  *|
|*     royalty-free copyright license to use this code in individual and     *| 
|*     commercial software.                                                  *|
|*                                                                           *|
|*     Any use of this source code must include, in the user documenta-      *|
|*     tion and internal comments to the code, notices to the end user       *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 2002 Matrox Graphics Inc. All rights reserved.            *|
|*                                                                           *|
|*     The source code is provided to you AS IS and WITH ALL FAULTS. Matrox  *|
|*     makes no representation and gives no warranty whatsoever, whether     *|
|*     express or implied, and without limitation, with regard to the        *|
|*     quality, safety, contents, performance, merchantability, non-         *|
|*     infringement or suitability for any particular or intended purpose    *|
|*     of this source code. In no event will Matrox be liable for any        *|
|*     direct, indirect, punitive, special, incidental or consequential      *|
|*     damages however they may arise and even if Matrox has been previously *|
|*     advised of the possibility of such damages.                           *|
|*                                                                           *|
 \***************************************************************************/
//***************************************************************************************
//
//Module Name:    OSTypes.h
//
//Description:    Content all OS specific types, constants, macros that should be defined
//                to get the OS independent code to compile.  You can include a header file
//                that defines all this stuff or you can define each conposant individually.
//
//References:     None.
//
//    Copyright (c) 2000, Matrox Graphics Inc.
//    All Rights Reserved.
//
//***************************************************************************************

#ifndef INC_OSTYPES_H
#define INC_OSTYPES_H

// --------------------------------------------------------------------------------------
//                      H E A D E R   F I L E S   R E Q U I R E D
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                                  C O N S T A N T S
// --------------------------------------------------------------------------------------


#define TCHAR           WCHAR
#define _T(string)      L ## string

#define IN
#define OUT
#define INOUT

#define TRUE            1
#define FALSE           0

#define __cdecl
#define __stdcall
#define CALLBACK
#define FAR
#define INLINE          __inline__
#define FINLINE         __inline__
#define OPTIONAL   
#define FIELD_OFFSET(type, field)    ((LONG)&(((type *)0)->field))

#define MTX_CODE_SEG_BEGIN
#define MTX_CODE_SEG_END

#ifndef EXTERN_C
  #ifdef __cplusplus
    #define EXTERN_C extern "C"
  #else  
    #define EXTERN_C extern
  #endif 
#endif 

// Must add this to compile for ia64.
#ifndef FASTCALL
  #if defined(_M_IX86)
    #define FASTCALL _fastcall
  #else
    #define FASTCALL
  #endif
#endif

// --------------------------------------------------------------------------------------
//                           T Y P E   D E F I N I T I O N S
// --------------------------------------------------------------------------------------

#if XF86_SUPPORT
 #define BOOL LBOOL
 #ifndef LONG64
  typedef int64_t                 INT64;
 #endif
#else
 typedef u_int8_t                BYTE;
 typedef unsigned long           BOOL;
 typedef __s8                    INT8;
 typedef __s16                   INT16;
 typedef __s32                   INT32;
 typedef int64_t                 INT64;
#endif

typedef BYTE*                   LPBYTE;
typedef BYTE*                   PBYTE;
typedef __u8                    UINT8;
typedef __u16                   UINT16;
typedef __u32                   UINT32;
typedef u_int64_t               UINT64;
typedef unsigned long           LBOOL;
typedef unsigned long           MUTEX;
typedef unsigned short          USHORT;
typedef float                   FLOAT;
typedef char *                  PSZ;
typedef double                  DOUBLE;
typedef long                    NTSTATUS;
typedef UINT16                  WORD;
typedef UINT32                  DWORD;
typedef long                    LONG;
typedef unsigned long           ULONG;
typedef ULONG                   FLONG;
typedef char                    CHAR;
typedef unsigned char           UCHAR;
typedef void                    VOID;
typedef void *                  LPVOID;
typedef const char *            PSTR;
typedef unsigned long           HANDLE;
typedef BOOL                    BOOLEAN;
typedef unsigned int            UINT;
typedef unsigned long           ULONG_PTR;
typedef unsigned long           DWORD_PTR;
typedef unsigned long long      DWORDLONG;
typedef long long               LONGLONG;
typedef unsigned long long      ULONGLONG;
typedef unsigned long*          PLONG;
#ifndef __KERNEL__
typedef wchar_t                 WCHAR;
#endif
typedef void                    (*PFN);

// These types are to be used for bit fields only
// to ensure all fields are of the same type.
typedef unsigned long           BFUNSIGNED;     // Unsigned bit field
typedef signed long             BFSIGNED;       // Signed bit field
typedef unsigned long           BFBOOL;         // Boolean bit field (1-bit only)

struct LPOINT               
{                                                   
     LONG   x;                                      
     LONG   y;                                      
};

struct LRECT                             
{                                                   
     LONG   left;                                   
     LONG   top;                                    
     LONG   right;                                  
     LONG   bottom;                                 
};

struct LSIZE
{
    LONG        cx;
    LONG        cy;
};

// Handy structure for (Width, Height) packed in a ULONG.
struct USHORT_SIZE
{
    USHORT  usWidth;                // @field Width
    USHORT  usHeight;               // @field Height
};

struct ULONG_SIZE
{
    ULONG   ulWidth;                // @field Width
    ULONG   ulHeight;               // @field Height
};


// Linux specific types
// including private data structures

#define LNX_COMMON_BUFFER_MAX_COUNT     4

#ifndef __KERNEL__
struct LnxCommonBufferInfo{

    DWORD dwPhysAddress;    // Phys address of common buffer
    VOID* pvAddress;        // Virtual address of common buffer
    ULONG ulSize;           // Size of buffer
    BOOL  bLocked;          // bLocked

};

struct OsDriverData {

};

struct OsDeviceData {

    HANDLE  hDriver;            // Handle to device driver
    UINT    uiMinor;            // Device file minor number

    ULONG   ulOpenCount;        // Number of device driver references opened
#if 0
    LPVOID  pvAgpAperture;      // AGP aperture virtual address
    DWORD   dwAgpApertureBase;  // AGP aperture physical address
    ULONG   ulAgpApertureSize;  // AGP aperture size
#endif
    BOOL    bDirectAccessUsed;  // Device enabled for direct accesses
    
    LnxCommonBufferInfo aoCommonBufferTable[4];   // Table of common buffers retrieved (max. 4)
};
#endif

// FIXME: Win types!
typedef struct LPOINT POINTL;
typedef struct LSIZE SIZEL;
typedef struct LRECT RECTL;

enum {
    BMF_1BPP    = 1,
    BMF_4BPP    = 4,
    BMF_8BPP    = 8,
    BMF_16BPP   = 16,
    BMF_24BPP   = 24,
    BMF_32BPP   = 32,
};

typedef union _LARGE_INTEGER{
    
    struct{
        
        DWORD LowPart;
        LONG HighPart;
    };
    
    LONGLONG QuadPart;
    
} LARGE_INTEGER;

typedef union _ULARGE_INTEGER{
    
    struct{
        
        DWORD LowPart;
        ULONG HighPart;
    };
    
    ULONGLONG QuadPart;
    
} ULARGE_INTEGER;

typedef FLOAT FLOATOBJ;
#define FLOATOBJ_Add(pFloat, pFloat2)      (*pFloat += *pFloat2)
#define FLOATOBJ_Mul(pFloat, pFloat2)      (*pFloat *= *pFloat2)
#define FLOATOBJ_SetLong(pFloat, lLong)   (*pFloat = lLong)
#define FLOATOBJ_GetLong(pFloat)          ((LONG)*pFloat)
#define FLOATOBJ_MulLong(pFloat, lLong)   (*pFloat *= lLong)
#define FLOATOBJ_DivLong(pFloat, lLong)   (*pFloat /= lLong)
#define FLOATOBJ_SetFloat(pFloat, fFloat) (*pFloat = fFloat)

// --------------------------------------------------------------------------------------
//                  G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------
// Macro used to generate compilation message

#define chSTR(x)    #x
#define chSTR2(x)   chSTR(x)

#if 0
    #define COMPMSG(x)  message(__FILE__ "(" chSTR2(__LINE__) ") : " #x)
#else
    #define COMPMSG(x)  
#endif
#endif  // #ifndef INC_OSTYPES_H

