 /***************************************************************************\
|*                                                                           *|
|*       Copyright 2002 Matrox Graphics Inc. All rights reserved.            *|
|*                                                                           *|
|*     NOTICE TO THE USER: This source code is the copyrighted work of       *| 
|*     Matrox. Users of this source code are hereby granted a nonexclusive,  *|
|*     royalty-free copyright license to use this code in individual and     *| 
|*     commercial software.                                                  *|
|*                                                                           *|
|*     Any use of this source code must include, in the user documenta-      *|
|*     tion and internal comments to the code, notices to the end user       *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 2002 Matrox Graphics Inc. All rights reserved.            *|
|*                                                                           *|
|*     The source code is provided to you AS IS and WITH ALL FAULTS. Matrox  *|
|*     makes no representation and gives no warranty whatsoever, whether     *|
|*     express or implied, and without limitation, with regard to the        *|
|*     quality, safety, contents, performance, merchantability, non-         *|
|*     infringement or suitability for any particular or intended purpose    *|
|*     of this source code. In no event will Matrox be liable for any        *|
|*     direct, indirect, punitive, special, incidental or consequential      *|
|*     damages however they may arise and even if Matrox has been previously *|
|*     advised of the possibility of such damages.                           *|
|*                                                                           *|
 \***************************************************************************/
/***************************************************************************************\

File Name:      MtxParhlDrv.h

Description:    Main header file for MTX parhelia core driver.

References:     None.

Author:         Karl Lessard    <klessard@matrox.com>

    Copyright (c) 2002, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXPARHLDRV_H
#define INC_MTXPARHLDRV_H

/*******************************************
 *
 * Included headers
 *
 ******************************************/

#include "parhl_regs.h"
#include "mtx_drv.h"

#include "MtxParhl.h"

#include "ParhlTypes.h"
#define   MEMHANDLE DWORD /* XXX */
#include "ParhlShare.h"

/******************************************
 *
 * Constants and types
 *
 *****************************************/

/* limit between both memory controller in local video aperture */
#define MM_LOCAL_CONTROLLER_LIMIT     (128L * (1024L * 1024L))

/*
 * MmMemoryController
 *
 * Different types of memory controller available for Parhelia board
 */
typedef enum {

    MM_MEMCTRL_AB,
    MM_MEMCTRL_CD,

    MM_MEMCTRL_COUNT,
    MM_MEMCTRL_INVALID
        
} MmMemoryController;

/*
 * MmMemoryLocation
 *
 * A memory location is a used to be more specific about
 * the memory region we are dealing with.
 */
typedef enum {

    MM_LOCAL_MEMTYPE_AB,
    MM_LOCAL_MEMTYPE_CD,
    MM_LOCAL_MEMTYPE_AB_COMMON,
    MM_LOCAL_MEMTYPE_CD_COMMON,
    MM_LOCAL_MEMTYPE_LINEAR,

    MM_LOCAL_MEMTYPE_COUNT,
    MM_LOCAL_MEMTYPE_INVALID
    
} MmLocalMemType;


/******************************************
 *
 * Data structures
 *
 *****************************************/

/*
 * mtx_parhl_device_t
 *
 * Parhelia core device data structure. This holds 
 * data specific to a parhelia board.
 */
typedef struct mtx_parhl_device {
   
    mtx_heap_group_t    aoLocalSurfaceHeaps[MM_LOCAL_MEMTYPE_COUNT];  /* Our surface heap groups */
    MmMemoryController  eNextAllocLocal;                  /* For next allocation in alternate local */
    MmMemoryController  eNextAllocLocalCommon;            /* Same, but for alternate common local */

    mtx_region_t        oSharedLockedRegion;              /* Shared locked data region */
    mtx_region_t        oSharedRegion;                    /* Shared data region */
    
    SharedLockedData   *poSharedLockedData;               /* Shared locked data */
    SharedData         *poSharedData;                     /* Shared data */
    SHwMemoryMapData   *poVideoInfo;                      /* Shortcut to memory map info */
    SHwRegisterMapData *poRegisterInfo;                   /* Shortcut to register map info */

} MtxParhlDevice;


/******************************************
 *
 * Helping macros
 *
 *****************************************/

/******************************************
 *
 * Internal functions prototype
 *
 *****************************************/

/* mtx_core */
int          MtxParhlInitDriver(void);
int          MtxParhlCleanupDriver(void);
int          MtxParhlEnableDevice(mtx_device_t* dev);
void         MtxParhlDisableDevice(mtx_device_t* dev);
int          MtxParhlOpenDevice(mtx_device_t* dev, mtx_context_t *ctx);
void         MtxParhlCloseDevice(mtx_device_t* dev, mtx_context_t *ctx);
mtx_ioctl_t* MtxParhlGetIoctl(unsigned int cmd_nr);

/* Parhelia ioctls */
int  MtxParhlIoctlAllocBlock(mtx_file_t*, unsigned int, unsigned long);
int  MtxParhlIoctlFreeBlock(mtx_file_t*, unsigned int, unsigned long);
int  MtxParhlIoctlGetLocalMemoryLayout(mtx_file_t*, unsigned int, unsigned long);

/* Parhelia surfaces */
int               MtxParhlSurfInit(mtx_device_t*);
void              MtxParhlSurfCleanup(mtx_device_t*);
mtx_heap_block_t* MtxParhlSurfAllocBlock(mtx_device_t*, MmSurfaceMemType, MmSurfaceDataType, ULONG);

/* Host apertures */
int               MtxParhlAptInit(mtx_device_t*);
void              MtxParhlAptCleanup(mtx_device_t*);
mtx_heap_block_t* MtxParhlAptLockAddressSpace(mtx_device_t*, ULONG, ULONG);
int               MtxParhlAptUnlockAddressSpace(mtx_device_t*, mtx_heap_block_t*);

#endif  // #ifndef INC_MTXPARHLDRV_H
