 /***************************************************************************\
|*                                                                           *|
|*       Copyright 2002 Matrox Graphics Inc. All rights reserved.            *|
|*                                                                           *|
|*     NOTICE TO THE USER: This source code is the copyrighted work of       *| 
|*     Matrox. Users of this source code are hereby granted a nonexclusive,  *|
|*     royalty-free copyright license to use this code in individual and     *| 
|*     commercial software.                                                  *|
|*                                                                           *|
|*     Any use of this source code must include, in the user documenta-      *|
|*     tion and internal comments to the code, notices to the end user       *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 2002 Matrox Graphics Inc. All rights reserved.            *|
|*                                                                           *|
|*     The source code is provided to you AS IS and WITH ALL FAULTS. Matrox  *|
|*     makes no representation and gives no warranty whatsoever, whether     *|
|*     express or implied, and without limitation, with regard to the        *|
|*     quality, safety, contents, performance, merchantability, non-         *|
|*     infringement or suitability for any particular or intended purpose    *|
|*     of this source code. In no event will Matrox be liable for any        *|
|*     direct, indirect, punitive, special, incidental or consequential      *|
|*     damages however they may arise and even if Matrox has been previously *|
|*     advised of the possibility of such damages.                           *|
|*                                                                           *|
 \***************************************************************************/
/***************************************************************************************\

File Name:      mtx.h

Description:    MTX interface. It can be directly included by any apps that want
                to communicate to the MTX driver, but most of them will preferred
                the core specific version depending on the board they want to run.

References:     None.

Author:         Karl Lessard    <klessard@matrox.com>

    Copyright (c) 2001, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTX_H
#define INC_MTX_H

#include <linux/ioctl.h>

/****************************************** 
 * Major/Minor device numbers handling 
 * 
 * (see mtx_open in kernel module)
 */
#define MTX_VERSION_MAJOR               0
#define MTX_VERSION_MINOR               1
#define MTX_VERSION_PATCH               8

#define MTX_MAJOR_NUMBER                0 /* Use dynamic major number allocation */
#define MTX_DRIVER_NAME                 "mtx"

#define MTX_MINOR_BUILD(bus, slot, func)  (((bus << 4) & 0xf0) | (slot & 0x1f))
#define MTX_MINOR_PCIBUS(minor)     ((minor >> 4) & 0xf)
#define MTX_MINOR_PCISLOT(minor)    ((minor >> 0) & 0xf)

#define AGPINFO_FLAG_DONE                 0x00000001L
#define AGPINFO_FLAG_PCIBOARD             0x00000002L
#define AGPINFO_FLAG_PCIXFER              0x00000004L
#define AGPINFO_FLAG_AGPBOARD             0x00000008L
#define AGPINFO_FLAG_AGPXFER              0x00000010L
#define AGPINFO_FLAG_AGPREADONLY          0x00000020L
#define AGPINFO_FLAG_AGPDELAY             0x00000040L
#define AGPINFO_FLAG_AGPSERIALIZE         0x00000080L
#define AGPINFO_FLAG_1XAFTERRESET         0x00000100L
#define AGPINFO_FLAG_HYBRID_CAP           0x00000200L
#define AGPINFO_FLAG_HYBRID_ENABLE        0x00000400L
#define AGPINFO_FLAG_FOUND_CHIPSET        0x00000800L
#define AGPINFO_FLAG_FOUND_CHIPSET_AGP    0x00001000L
#define AGPINFO_FLAG_FOUND_CHIPSET_ISA    0x00002000L
#define AGPINFO_FLAG_PCIALIGN64           0x00004000L
#define AGPINFO_FLAG_FASTWRITE            0x00008000L
#define AGPINFO_FLAG_PCIMEMORY            0x00010000L
#define AGPINFO_FLAG_AGPMEMORY            0x00020000L


/******************************************
 * Types 
 * 
 * (shared between user-process 
 * and kernel module)
 *
 */

typedef enum {
   
    MTX_MEMTYPE_IO, /* or LOCAL */
    MTX_MEMTYPE_PCI_LOCKED,
    MTX_MEMTYPE_AGP,
    MTX_MEMTYPE_SYS,

    MTX_MEMTYPE_COUNT, /* number of memory types */

} mtx_memory_type;

#define MTX_MEMTYPE_LOCAL   MTX_MEMTYPE_IO

typedef enum {

    MTX_SHARETYPE_NONE,
    MTX_SHARETYPE_USERONLY,
    MTX_SHARETYPE_KERNEL,

} mtx_share_type;


/******************************************
 * Ioctls structures
 *
 */

/* GET MEMORY INFO */
typedef struct mtx_ioctl_get_memory_info {

    unsigned long   fb_base;            /* framebuffer base */
    unsigned long   fb_size;            /* framebuffer size */
    
    unsigned long   reg_base;           /* control registers base */
    unsigned long   reg_size;           /* control registers size */

    unsigned long   agp_base;           /* AGP space base */
    unsigned long   agp_size;           /* AGP space size */
    
} mtx_ioctl_get_memory_info_t;


/* ALLOC BUFFER */
typedef struct mtx_ioctl_buffer {

    int                 context_id;     /* Unique id of calling context */

    unsigned long       size;           /* Desired size of buffer */
    unsigned long       base;           /* Buffer returned physical address */

    mtx_memory_type     type;           /* Buffer memory type */

} mtx_ioctl_buffer_t;


/******************************************
 * Ioctls definition
 * 
 */
#define MTX_IOCTL_MAGIC             'F'
#define MTX_IO(nr, offset)          _IO(MTX_IOCTL_MAGIC, (nr + offset))
#define MTX_IOR(nr, offset, arg)    _IOR(MTX_IOCTL_MAGIC, (nr + offset), arg)
#define MTX_IOW(nr, offset, arg)    _IOW(MTX_IOCTL_MAGIC, (nr + offset), arg)
#define MTX_IOWR(nr, offset, arg)   _IOWR(MTX_IOCTL_MAGIC, (nr + offset), arg)

/* core ioctl number offsets and range */
#define MTX_IOCTL_NROFF             0
#define MTX_PARHL_IOCTL_NROFF       10
#define MTX_IOCTL_RANGE             10 /* always a max range of 10 ioctls */

/* XXX: Always update MTX_IOCTL_MAXNR when adding a new ioctl. */
#define MTX_IOCTL_MAXNR             0x08

#define MTX_IOCTL_HARD_RESET        MTX_IO(0x00, MTX_IOCTL_NROFF)  /* for debugging only */
#define MTX_IOCTL_GET_MEMORY_INFO   MTX_IOR(0x01, MTX_IOCTL_NROFF, mtx_ioctl_get_memory_info_t)
#define MTX_IOCTL_ALLOC_BUFFER      MTX_IOWR(0x02, MTX_IOCTL_NROFF, mtx_ioctl_buffer_t)
#define MTX_IOCTL_FREE_BUFFER       MTX_IOW(0x03, MTX_IOCTL_NROFF, mtx_ioctl_buffer_t)
#define MTX_IOCTL_GET_SHARED_BUFFER MTX_IOWR(0x04, MTX_IOCTL_NROFF, mtx_ioctl_buffer_t)
#define MTX_IOCTL_RELEASE_SHARED_BUFFER MTX_IOW(0x05, MTX_IOCTL_NROFF, mtx_ioctl_buffer_t)
#define MTX_IOCTL_BUSMASTERING_TEST MTX_IOW(0x06, MTX_IOCTL_NROFF, mtx_ioctl_buffer_t)
#define MTX_IOCTL_ADD_CONTEXT       MTX_IOR(0x07, MTX_IOCTL_NROFF, int)
#define MTX_IOCTL_REMOVE_CONTEXT    MTX_IOW(0x08, MTX_IOCTL_NROFF, int)

/* Core drivers ioctls */
#include "parhelia/MtxParhl.h"

#endif  /* #ifndef INC_MTX_H */
