#
# Config makefile for parhelia
#
# Copyright (c) 2001, Matrox Graphics Inc.
# All rights reserved.
#

export YES = 1
export NO  = 0


#...................... BUILD FLAGS.......................

# Debug main switch
# -----------------
#
# Set this flag if you want debug 
# messages from Parhelia driver
CFG_DEBUG=NO

# Simulator main switch
# ---------------------
# TRUE:    Insert a support for simulator in driver.
#          Direct accesses to the board's registers are sent to the simulator
#          to update simulator internal states
#          Dumping of .in's file is enabled in driver. 
#          When dumping .in's file, the BM buffers are parsed 
#          by CModel DMA section and written into a file.
#          Depending of value of compilation switch RENDER_USING_SIMULATOR 
#          rendering is done on simulator or on parhelia engine
# FALSE:   removes all CModel depending code.
CFG_SIMULATOR=NO

# Memory statistics
# ---------------------
# TRUE:    Memory statistics tracking
#          Keeps track of memory allocation and offer services to easily 
#          dump statistics collected
# FALSE:   Use normal usage of memory allocation
CFG_MEMORY_STATS=YES

# DMA emulation switch
# ---------------------
# TRUE:    Insert DMA emulation support in driver.
#          All DMA buffers/requests are handled and process by software
#          via MMIO slave accesses. This included also shader buffers.
# FALSE:   Dispatch DMA buffers to hardware.
CFG_EMULATE_DMA=NO

# Bus mastering switch
# --------------------
# TRUE:    Add busmastering support
#          Enable bus mastering for sending drawing commands to the 
#          hardware.
# FALSE:   Only support MMIO accesses
CFG_BUS_MASTERING=NO


#...................... OS-SUPPORT .......................

# Select the operating system for which the driver 
# will be used. 
# For now, only one OS at a time is supported

CFG_OS_LINUX=YES
#CFG_OS_WIN32=YES
