/********************************************************
*  mgaXaction.h
*
*  Header file for Matrox video parameters tuning utility.
*  Interface-independant functions.  Commands for driver.
*
*  Copyright (C) 2001, Matrox Graphics Inc.
*
*  Author : Stephane Duguay
*  Last modified : April 2001.
*********************************************************/

#ifndef MGAXACTION_H
#define MGAXACTION_H

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>

#include <X11/extensions/xf86vmode.h>

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

void moveScreenLeft(XF86VidModeModeLine* pModeLine, Display* pDisp);
void moveScreenRight(XF86VidModeModeLine* pModeLine, Display* pDisp);
void moveScreenUp(XF86VidModeModeLine* pModeLine, Display* pDisp);
void moveScreenDown(XF86VidModeModeLine* pModeLine, Display* pDisp);
void resizeScreenWider(XF86VidModeModeLine* pModeLine, Display* pDisp);
void resizeScreenNarrower(XF86VidModeModeLine* pModeLine, Display* pDisp);
void resizeScreenShorter(XF86VidModeModeLine* pModeLine, Display* pDisp);
void resizeScreenTaller(XF86VidModeModeLine* pModeLine, Display* pDisp);
void applyNewRefresh(XF86VidModeModeLine* pModeLine, Display* pDisp, int refresh);
void UndoLastChange(XF86VidModeModeLine* pModeLine, Display* pDisp);

BOOL SendMGACmd(char *mgaCMD,char* sResult, XF86VidModeModeLine* pModeLine, Display* pDisp);

BOOL isHalLoaded(XF86VidModeModeLine* pModeLine, Display* pDisp);
BOOL isDriverModed(XF86VidModeModeLine* pModeLine, Display* pDisp);

#endif
