/********************************************************
*  io.c
*
*  Source file for Matrox video parameters tuning utility.
*  Functions to access io. Reads BIOS version and BusID.
*
*  Copyright (C) 2001, Matrox Graphics Inc.
*
*  Author : Luugi Marsan and Stephane Duguay
*  Last modified : April 2001.
*********************************************************/

/* Read Bios Version */

#include "global.h"
#include "io.h"

static int int_pci_conf1_read_config_dword(unsigned char bus, unsigned char device_fn, unsigned char where, unsigned int *value)
{ 
	outl(CONFIG_CMD(bus,device_fn,where), 0xCF8 );
	*value = inl(0xCFC); 
	return 1;
}

static int int_pci_conf1_write_config_dword(unsigned char bus, unsigned char device_fn, unsigned char where, unsigned int value)
{ 
	outl(CONFIG_CMD(bus,device_fn,where), 0xCF8 );
	outl(value, ((0xCFC + (where & 3)))); 
	return 1;
}

void DisplayBiosVersion(char* buffer, int bufferLen){

	unsigned int uiBiosVersion;
	unsigned int uiBuild,uiMinor, uiMajor;

	if (device_info.id == 0)
	{
		snprintf(buffer, bufferLen, "Unknown");
		return;
	}

	uiBiosVersion = getBiosVersion();

	if (uiBiosVersion == 0)
	{
		buffer = NULL;
		return;
	}

	uiBuild = uiBiosVersion & 0xfff;
	uiMinor = (uiBiosVersion & 0xf000) >> 12;
	uiMajor = (uiBiosVersion & 0xffff0000) >> 16;

	snprintf(buffer, bufferLen, "%u.%u - %u",uiMajor,uiMinor,uiBuild);
}

unsigned long getBiosVersion()
{
	unsigned char ucBusNum;
	unsigned char ucDevice_fn;
	unsigned int uiVendor; 
	int fd;

	volatile unsigned char *base; 
	unsigned char* Base;  

	unsigned int ulOrgOption;
	unsigned int ulROMBASE;
	unsigned int ulTmpDword;
	unsigned int ulOrgRomBase;

	unsigned int pulBIOSVersion; 
	unsigned int ulPCIINFOOffset;
	unsigned char ucTmpByte; 
	
	/****
	 Very Important
	 Must be root to access required IO Ports. 
	*****/

	/* Asking for all port access */
	if(iopl(3)){
		printf(" You must be ROOT! \n\n");
		exit(1);
	}

	/* Detect card now.. */

	for(ucBusNum = 0; ucBusNum < 16; ucBusNum++)
		for(ucDevice_fn = 0; ucDevice_fn < 32; ucDevice_fn++) {

			int_pci_conf1_read_config_dword(ucBusNum, ucDevice_fn, 0x00, &uiVendor);

			if((uiVendor & 0xffff) == 0x102b) { 

				int_pci_conf1_read_config_dword(ucBusNum, ucDevice_fn, 0x04, &ulTmpDword);
				ulTmpDword = ulOrgOption | 0x00000002;  /*biosen*/
				int_pci_conf1_write_config_dword(ucBusNum,ucDevice_fn, 0x04, ulTmpDword);
				/* READ BIOS VERSION*/

				/* Enable bios */
				int_pci_conf1_read_config_dword(ucBusNum, ucDevice_fn, 0x40, &ulOrgOption);
				ulTmpDword = ulOrgOption | 0x40000000;  /*biosen*/
				int_pci_conf1_write_config_dword(ucBusNum,ucDevice_fn, 0x40, ulTmpDword);


				/*Map the BIOS over the frame buffer */
				int_pci_conf1_read_config_dword(ucBusNum, ucDevice_fn,0x30, &ulOrgRomBase);
				int_pci_conf1_read_config_dword(ucBusNum, ucDevice_fn, 0x10, &ulTmpDword);
				ulTmpDword = (ulTmpDword & 0xFF000000) | 0x00000001;
#ifdef DEBUG
				printf("Inserting %x to ROMBASE\n",ulTmpDword);
#endif
				int_pci_conf1_write_config_dword(ucBusNum, ucDevice_fn, 0x30, ulTmpDword);

				ulTmpDword &= 0xFFFF0000;
				ulROMBASE = ulTmpDword;
				Base = (unsigned char *)((unsigned long) (ulROMBASE)); 

				/* Open mem Map */
				fd=(open("/dev/mem",O_RDWR));
				if(fd < 0) {
					printf("open Error - Quiting \n"); 
					exit(-1);
				}

				/* Assign 32k  */
				base = (unsigned char*) malloc(0x8000 + 0x1000); // register apperature size
				base = (unsigned char*)( ((unsigned int)base & ~0xFFF) + 0x1000); // Allign Page Boundaries
				base = (unsigned char *) mmap((caddr_t)base, 0x8000, PROT_READ|PROT_WRITE, 
						MAP_FIXED|MAP_SHARED, fd, (off_t)Base);

				if(base == NULL) {
					printf("Map Unsuccessfull\n");
					iopl(0);
					return 0;
				}

				if (base[0]== 0x55){
					if(base[1] == 0xaa){
						ulPCIINFOOffset = *((long *)(&base[0x18]));
						ulPCIINFOOffset &= 0x0000FFFF ;
						ulTmpDword = *((long *)(&base[ulPCIINFOOffset]));
						if (ulTmpDword == 0x52494350)   // "PCIR"
						{
							ulPCIINFOOffset += 0x12;     // PCIINFOffset point to the BIOS REV
							ulTmpDword = *((long *)(&base[ulPCIINFOOffset]));
							pulBIOSVersion = ((unsigned long)((ulTmpDword & 0xf0) >> 4) << 16) | ((ulTmpDword & 0xf) << 12)  | ((ulTmpDword >> 8) & 0xff);
					
#ifdef DEBUG
							printf("THE BIOS VERSION IS 0x%x \n",pulBIOSVersion);
#endif
							int_pci_conf1_write_config_dword(ucBusNum, ucDevice_fn, 0x30, ulOrgRomBase);
							int_pci_conf1_write_config_dword(ucBusNum, ucDevice_fn, 0x40, ulOrgOption);
							iopl(0);
							return pulBIOSVersion;
						}
						else{
							ucTmpByte = base[5];
							pulBIOSVersion = ((unsigned long)(ucTmpByte >> 4) << 16) | ((unsigned long)(ucTmpByte & 0xf) << 12);
							int_pci_conf1_write_config_dword(ucBusNum, ucDevice_fn, 0x30, ulOrgRomBase);
							int_pci_conf1_write_config_dword(ucBusNum, ucDevice_fn, 0x40, ulOrgOption);
#ifdef DEBUG
							printf("THE BIOS VERSION IS %x\n",pulBIOSVersion);
#endif
							iopl(0);
							return pulBIOSVersion;
						}

					}

				}
			}


		}

	iopl(0);
	return 0;

}

int getMatroxPci(int* deviceNum, int* busNum, int* deviceId, unsigned char* revision)
{
	unsigned char ucBusNum, ucDevice_fn;
	unsigned int uiDeviceID, uiRevision;

	/* Asking for all port access */
	if(iopl(3))
	{
		printf(" You must be ROOT! \n\n");
		exit(1);
	}

	for(ucBusNum = 0; ucBusNum < 16; ucBusNum++)
	{
		for(ucDevice_fn = 0; ucDevice_fn < 32; ucDevice_fn++)
		{
			int_pci_conf1_read_config_dword(ucBusNum, ucDevice_fn, 0x00, &uiDeviceID);
			
			/* vendor is Matrox? */
			if((uiDeviceID & 0xffff) == 0x102b)
			{
				*busNum = ucBusNum;
				*deviceNum = ucDevice_fn;
				
				int_pci_conf1_read_config_dword(ucBusNum, ucDevice_fn, 0x08, &uiRevision);
				
				*deviceId = (uiDeviceID & 0xffff0000) >> 16;
				*revision = uiRevision & 0xff;
				
				iopl(0);
				return 1;
			}

		}
	}

	*deviceId = 0;
	*revision = 0;

	return 0;

}
