/********************************************************
*  global.h
*
*  Header file for Matrox video parameters tuning utility.
*  Global variables and utils.
*
*  Copyright (C) 2001, Matrox Graphics Inc.
*
*  Author : Karl Lessard
*  Last modified : May 2001.
*********************************************************/

#ifndef _GLOBAL_H_

#include <X11/Xlib.h>
#include <X11/extensions/xf86vmode.h>

struct DeviceInfo
{
    int dot_clock;
    unsigned int id;
    unsigned char rev;
};


/* Global Variables */
Display* pDisp;
XF86VidModeModeLine mode_line;
struct DeviceInfo device_info;

#define DEV_IS_G450()		(device_info.id == 0x0525    				/* G400 dev id */		\
						 	 && device_info.rev >= 0x80) 				/* G450 revision */
#define DEV_IS_G400()		(device_info.id == 0x0525 	 				/* G400 dev id */		\
						 	 && device_info.rev < 0x80) 				/* not G450 revision */	
#define DEV_IS_G200()		(device_info.id == 0x0521 	 				/* G200 AGP dev id */	\
						 	  || device_info.id == 0x0520)				/* G200 PCI dev id */  	
#define DEV_IS_G100()		(device_info.id == 0x1001 					/* G100 AGP dev id */	\
						 	 || device_info.id == 0x1000)				/* G100 PCI dev id */

#endif
