/* $Id: general_clip.h,v 1.2.2.1 2000/04/10 22:01:52 brianp Exp $ */

/*
 * Mesa 3-D graphics library
 * Version:  3.2
 * 
 * Copyright (C) 1999-2000  Brian Paul   All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/*
 * New (3.1) transformation code written by Keith Whitwell.
 */


/*
 * NOTE: The tests such as this:  X(in) - W(in) == dw - dx
 * were added to stop a clipping problem found in Unreal Tournament.
 * The patch was contributed by Andreas Ehliar <ehliar@lysator.liu.se>.
 * There's some concern that this just fixes a problem which occurs
 * earlier in transformation.  Well, until that (unknown) problem is
 * fixed, this will have to do.
 */



/*
 * Clip against +X
 *
 * The if conditions are known at compile time.
 */
#define PLANE          (CLIP_RIGHT_BIT)
#define INSIDE(K)      (X(K) <= W(K))
#define COMPUTE_INTERSECTION( in, out, new )				\
	dx = X(out) - X(in);						\
	dw = W(out) - W(in);						\
	if (X(in) - W(in) == dw - dx)					\
	   t = 1.0F;							\
	else								\
	   t = (X(in) - W(in)) / (dw - dx);				\
	neww = W(in) + t * dw;						\
	X(new) = neww;							\
	Y(new) = Y(in) + t * (Y(out) - Y(in));				\
	if (SIZE>=3) coord[new][2] = Z(in) + t * (Z(out) - Z(in));	\
	if (SIZE==4) coord[new][3] = neww;

   GENERAL_CLIP

#undef INSIDE
#undef PLANE
#undef COMPUTE_INTERSECTION


/*
 * Clip against -X
 */
#define PLANE          (CLIP_LEFT_BIT)
#define INSIDE(K)       (X(K) >= -W(K))
#define COMPUTE_INTERSECTION( in, out, new )				\
	dx = X(out) - X(in);						\
	dw = W(out) - W(in);						\
	if (X(in) + W(in) == dw + dx)					\
	   t = 1.0F;							\
	else								\
	   t = -(X(in) + W(in)) / (dw + dx);				\
	neww = W(in) + t * dw;						\
	X(new) = -neww;							\
	Y(new) = Y(in) + t * (Y(out) - Y(in));				\
	if (SIZE>=3) coord[new][2] = Z(in) + t * (Z(out) - Z(in));	\
	if (SIZE==4) coord[new][3] = neww;

   GENERAL_CLIP

#undef INSIDE
#undef PLANE
#undef COMPUTE_INTERSECTION


/*
 * Clip against +Y
 */
#define PLANE	  (CLIP_TOP_BIT)
#define INSIDE(K)       (Y(K) <= W(K))
#define COMPUTE_INTERSECTION( in, out, new )				\
	dy = Y(out) - Y(in);						\
	dw = W(out) - W(in);						\
	if (Y(in) - W(in) == dw - dy)					\
	   t = 1.0F;							\
	else								\
	   t = (Y(in) - W(in)) / (dw - dy);				\
	neww = W(in) + t * dw; 						\
	X(new) = X(in) + t * (X(out) - X(in));				\
	Y(new) = neww;							\
	if (SIZE>=3) coord[new][2] = Z(in) + t * (Z(out) - Z(in));	\
	if (SIZE==4) coord[new][3] = neww;

   GENERAL_CLIP

#undef INSIDE
#undef PLANE
#undef COMPUTE_INTERSECTION


/*
 * Clip against -Y
 */
#define PLANE	  (CLIP_BOTTOM_BIT)
#define INSIDE(K)       (Y(K) >= -W(K))
#define COMPUTE_INTERSECTION( in, out, new )				\
	dy = Y(out) - Y(in);						\
	dw = W(out) - W(in);						\
	if (Y(in) + W(in) == dw + dy)					\
	   t = 1.0F;							\
	else								\
	   t = -(Y(in) + W(in)) / (dw + dy);				\
	neww = W(in) + t * dw;						\
	X(new) = X(in) + t * (X(out) - X(in));				\
	Y(new) = -neww;							\
	if (SIZE>=3) coord[new][2] = Z(in) + t * (Z(out) - Z(in));	\
	if (SIZE==4) coord[new][3] = neww;

   GENERAL_CLIP

#undef INSIDE
#undef PLANE
#undef COMPUTE_INTERSECTION



/*
 * Clip against +Z
 */
#define PLANE	  (CLIP_FAR_BIT)
#define INSIDE(K)       (Z(K) <= W(K))
#define COMPUTE_INTERSECTION( in, out, new )				\
	dz = Z(out) - Z(in);						\
	dw = W(out) - W(in);						\
	if (Z(in) - W(in) == dw - dx)					\
	   t = 1.0F;							\
	else								\
	   t = (Z(in) - W(in)) / (dw - dz);				\
	neww = W(in) + t * dw;						\
	X(new) = X(in) + t * (X(out) - X(in));				\
	Y(new) = Y(in) + t * (Y(out) - Y(in));				\
	coord[new][2] = neww;						\
	if (SIZE==4) coord[new][3] = neww;

   if (SIZE >= 3) { 
      GENERAL_CLIP
   }

#undef INSIDE
#undef PLANE
#undef COMPUTE_INTERSECTION


/*
 * Clip against -Z
 */
#define PLANE	  (CLIP_NEAR_BIT)
#define INSIDE(K)       (Z(K) >= -W(K))
#define COMPUTE_INTERSECTION( in, out, new )				\
	dz = Z(out) - Z(in);						\
	dw = W(out) - W(in);						\
	if (Z(in) + W(in) == dw + dz)					\
	   t = 1.0F;							\
	else								\
	   t = -(Z(in) + W(in)) / (dw + dz);				\
	neww = W(in) + t * dw;						\
	X(new) = X(in) + t * (X(out) - X(in));				\
	Y(new) = Y(in) + t * (Y(out) - Y(in));				\
	coord[new][2] = -neww;						\
	if (SIZE==4) coord[new][3] = neww; 

   if (SIZE >=3 ) { 
      GENERAL_CLIP
   }

#undef INSIDE
#undef PLANE
#undef COMPUTE_INTERSECTION
#undef GENERAL_CLIP
