
/*
 * GLX Server Extension
 * Copyright (C) 1996  Steven G. Parker  (sparker@cs.utah.edu)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * STEVEN PARKER, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR 
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


#ifndef GLXVISUAL_H
#define GLXVISUAL_H 1

#include "xsmesa.h"

typedef struct GLScreen {
    int numVisuals;
    XSMesaVisual* visuals;
} GLScreen;

#ifdef __cplusplus                                                              
#define CLASS x_class                                                           
#else                                                                           
#define CLASS class                                                             
#endif

typedef struct Vis                                                              
{                                                                               
    VisualPtr orig_visual;                                                      
    DepthPtr depth;                                                             
    struct Vis* next;                                                           
    int usegl;                                                                  
    int rgb, db, alpha, stencil, depthb, accum;                                 
    VisualID vid;
} Vis;

typedef struct  {
   VisualPtr visual;
   DepthPtr  depth;
   int       nvisual;
   int       ndepth;
   int       *rootDepthp;
   VisualID  *defaultVisp;
   unsigned long  sizes;
   int       bitsPerRGB;
} VisInitialization;


extern GLScreen __glScreens[];
extern Vis*     __vislist;
                                                                                
Bool XSMesaInitVisuals(VisualPtr *, DepthPtr *, int *, int *, int *, VisualID *,
 unsigned long, int);
void GLFinalizeVisuals();


Bool GlxInitVisuals (VisualPtr   *visualp, 
		     DepthPtr    *depthp,
		     int         *nvisualp, 
		     int         *ndepthp,
		     int         *rootDepthp,
		     VisualID    *defaultVisp,
		     unsigned long   sizes,
		     int     bitsPerRGB );

void GlxExtensionInit();


#endif
