/*
 * GLX Hardware Device Driver for Matrox G200/G400
 * Copyright (C) 1999 Wittawat Yamwong
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *    Wittawat Yamwong <Wittawat.Yamwong@stud.uni-hannover.de>
 */

/* $Id: mgadd.c,v 1.35 2000/04/26 13:14:35 ehliar Exp $ */


#include <stdlib.h>
#include <stdio.h>

#include "mesaglx/types.h"
#include "vbrender.h"
#include "glx_log.h"
#include "glx_config.h"
#include "hw_buffer.h"

#include "mm.h"
#include "g200_mac.h"
#include "mgalib.h"
#include "mgaglx.h"
#include "mgaclear.h"
#include "mgadd.h"
#include "mgadirect.h"
#include "hwlog.h"
#include "mgastate.h"
#include "mgatex.h"
#include "mgatris.h"
#include "mgavb.h"
#include "extensions.h"
#include "vb.h"
#include "dd.h"
#include "mgapixel.h"

#include "pixmapstr.h"	/* X: for _Drawable */
#include "pixmap.h"		/* X: for window DrawablePtr */

extern XSMesaContext XSMesa;


/***************************************
 * Mesa's Driver Functions
 ***************************************/


const GLubyte *mgaDDGetString( GLcontext *ctx, GLenum name )
{
   switch (name) {
   case GL_VENDOR:
      return "Utah GLX";
   case GL_RENDERER:
      if (mgaglx.isG200) return "GLX-MGA-G200";
      if (mgaglx.isG400) return "GLX-MGA-G400";
      return "GLX-MGA";
   default:
      return "";
   }
}


void mgaDDExtensionsInit( GLcontext *ctx )
{
   /* CVA only available for direct contexts.
    */
   if (__glx_is_server) 
      gl_extensions_disable( ctx, "GL_EXT_compiled_vertex_array" );

   /* paletted_textures currently doesn't work, but we could fix them later */
      gl_extensions_disable( ctx, "GL_EXT_shared_texture_palette" );
//      gl_extensions_disable( ctx, "GL_EXT_paletted_texture" );

   /* Support multitexture only on the g400.
    */
   if (!mgaglx.isG400 || glx_getint("mga_no_multitex")) 
   {
      gl_extensions_disable( ctx, "GL_EXT_multitexture" );
      gl_extensions_disable( ctx, "GL_SGIS_multitexture" );
      gl_extensions_disable( ctx, "GL_ARB_multitexture" );
   }

   /* Turn on texenv_add for the G400.
    */
   if ( mgaglx.isG400 && !glx_getint("mga_no_texenvadd"))
   {
      gl_extensions_enable( ctx, "GL_EXT_texture_env_add" );
   }

   /* we don't support point parameters in hardware yet */
   gl_extensions_disable( ctx, "GL_EXT_point_parameters" );

   /* No support for fancy imaging stuff.  This should kill off 
    * a few rogue fallbacks.
    */
   gl_extensions_disable( ctx, "ARB_imaging" );
   gl_extensions_disable( ctx, "GL_EXT_blend_minmax" );
   gl_extensions_disable( ctx, "GL_EXT_blend_logic_op" );
   gl_extensions_disable( ctx, "GL_EXT_blend_subtract" );
   gl_extensions_disable( ctx, "GL_INGR_blend_func_separate" );   
}


static GLint mgaGetParameteri(const GLcontext *ctx, GLint param)
{
  switch (param) {
  case DD_HAVE_HARDWARE_FOG:  
    return 1; 
  default:
    hwError("mgaGetParameteri(): unknown parameter!\n");
    return 0; /* Should I really return 0? */
  }
}

void mgaSetSpanFunctions( GLcontext *ctx ) {
	cbFormat_t	cbFormat;
	dbFormat_t	dbFormat;
	
	if ( !mgaDB ) {
		return;
	}
	/* set all the buffer access functions based on bit depth */
	if ( ( mgaDB->Setup[MGA_SETUP_MACCESS] & 3 ) == 2 ) {
		cbFormat = CB_32BIT_BGRA;
	} else if ( mgaDB->Setup[MGA_SETUP_MACCESS] & (1<<31) ) {
		cbFormat = CB_15BIT;
	} else {
		cbFormat = CB_16BIT;
	}
	
	if ( mgaDB->bytesPerDepth == 2 ) {
		dbFormat = DB_16BIT;
	} else if ( mgaDB->bytesPerDepth == 4 ) {
		if ( mgaDB->hasStencil ) {	
			dbFormat = DB_24BIT_SB_8BIT;
		} else {
			dbFormat = DB_32BIT;
		}	
	}
		
	SetDriverBufferFunctions( ctx, mgaDmaFinish,
		mgaDB->backBuffer, mgaDB->pitch, mgaDB->height, cbFormat,
		mgaDB->depthBuffer, mgaDB->pitch, mgaDB->height, dbFormat );
}


/*
 * We allways have a single back buffer, but
 * if we are in "front buffer" mode, we will automatically
 * generate flush events
 */
static GLboolean mgaDDSetBuffer( GLcontext *ctx, GLenum mode )
{
	return 1;
}

/*
 * Return the size of the current color buffer, checking to see if the
 * window has been resized.
 * There isn't an explicit "size has changed" entry point, so this serves
 * double duty.
 */
static void mgaDDGetBufferSize( GLcontext *ctx, GLuint *width, GLuint *height )
{
	XSMesaContext		xsmesa;
	XSMesaBuffer		b;
	DrawablePtr			window;
	unsigned int		winwidth, winheight;

	xsmesa = (XSMesaContext) ctx->DriverCtx;
	b = xsmesa->xsm_buffer;
	window = b->frontbuffer;

	winwidth = window->width;
	winheight = window->height;
	*width = winwidth;
	*height = winheight;

	/* see if it has changed size */
	if ( winwidth != b->width || winheight != b->height ) {
	        b->width = winwidth;
	        b->height = winheight;

	        /* Allocate new back buffer :
		 * (also deallocate the old backimage, if any) */
	        b->backimage = mgaGLXCreateImage( (WindowPtr)b->frontbuffer,
						     b->xsm_visual->gl_visual,
						     b->width,
						     b->height,
						     b->backimage );

		/* make it current */
		XSMesa = NULL;	/* force it to reset things */
		mgaGLXBindBuffer( xsmesa, b );
	}
}

static void mgaDDFlush( GLcontext *ctx )
{
	// if we are front buffer rendering, fake up a swapbuffers
	if ( !mgaDB ) {
		return;
	}	
	if ( ctx->Color.DriverDrawBuffer == GL_FRONT 
	||  ctx->Color.DriverDrawBuffer == GL_FRONT_LEFT 
	||  ctx->Color.DriverDrawBuffer == GL_FRONT_RIGHT 
	 ) {
		mgaGLXSwapBuffers( mgaDB->xsBuf );
	}
}


static void mgaDDClearColor( GLcontext *ctx, GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha )
{
	/* we just look in the context when we clear, but mesa
	 * requires this function to exist
	 */
}

static void mgaDDAllocDepthBuffer( GLcontext *ctx )
{
	/* we always allocate the depth buffer with the color buffer */
}

/*
 * A context can change back and forth from accelerated to non-accelerated
 * if it's buffer is resized or it is bound to a different buffer.
 */ 
static void mgaDisableHW(GLcontext *ctx)
{
	/* disable hardware accel. */
	hwMsg(5,"no hw accel.\n");

	SetSoftwareDriverFunctions( ctx );
	mgaSetSpanFunctions( ctx );

	ctx->Driver.GetBufferSize = mgaDDGetBufferSize;
}

/*
 * mga_setup_DD_pointers
 * This is called at each context or buffer bind
 */
void mga_setup_DD_pointers( GLcontext *ctx ) {
	if ( !mgaDB || !mgaDB->backBufferBlock ) {
		mgaDisableHW(ctx);	
		return;
	}

	memset( &ctx->Driver, 0, sizeof( ctx->Driver ) );
	
	ctx->Driver.GetBufferSize = mgaDDGetBufferSize;
	ctx->Driver.AllocDepthBuffer = mgaDDAllocDepthBuffer;
	ctx->Driver.SetBuffer = mgaDDSetBuffer;
	ctx->Driver.ClearColor = mgaDDClearColor;
	ctx->Driver.Finish = mgaDDFlush;
	ctx->Driver.Flush = mgaDDFlush;
#if 0
	ctx->Driver.DrawPixels = mgaDDDrawPixels; 
	ctx->Driver.Bitmap = mgaDDBitmap;
#endif
	ctx->Driver.Viewport = mgaDDViewport;
	ctx->Driver.DepthRange = mgaDDDepthRange;
	ctx->Driver.GetString = mgaDDGetString;
	ctx->Driver.UpdateState = mgaDDUpdateState;
	ctx->Driver.RegisterVB = mgaDDRegisterVB;
	ctx->Driver.UnregisterVB = mgaDDUnregisterVB;
	ctx->Driver.Clear = mgaClear;
	ctx->Driver.GetParameteri = mgaGetParameteri;
	ctx->Driver.TexEnv = mgaTexEnv;
	ctx->Driver.TexImage = mgaTexImage;
	ctx->Driver.TexSubImage = mgaTexSubImage;
	ctx->Driver.BindTexture = mgaBindTexture;
	ctx->Driver.DeleteTexture = mgaDeleteTexture;
	ctx->Driver.TexParameter = mgaTexParameter;
	ctx->Driver.UpdateTexturePalette = mgaUpdateTexturePalette;
	ctx->Driver.IsTextureResident = mgaIsTextureResident;
	if(!mgaglx.noFastpath){
		ctx->Driver.BuildPrecalcPipeline = mgaDDBuildPrecalcPipeline;
	}

	ctx->Driver.TriangleCaps = (DD_TRI_CULL|
			       DD_TRI_LIGHT_TWOSIDE|
			       DD_TRI_OFFSET);

	mgaSetSpanFunctions( ctx );

				      
	mgaDDInitStatePointers(ctx);

	/* Also do the normal GL state-change checks.
	 */
	mgaDDUpdateState( ctx );
}
